@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

@php
    use Carbon\Carbon;

    // ===== Config de liberação (ajuste a data se precisar) =====
    $tz    = 'America/Sao_Paulo';
    // AJUSTE: A data foi corrigida para 18/08, conforme o texto informativo.
    $start = Carbon::create(2025, 8, 18, 8, 0, 0, $tz);
    $now   = Carbon::now($tz);

    // Quantos módulos já foram liberados cumulativamente
    if ($now->lt($start)) {
        $releasedCount = 0;
    } else {
        $releasedCount = min(5, $start->diffInDays($now) + 1);
    }

    // Dados dos módulos
    $mods = [
        1 => ['bg' => 'bodyModulo1', 'img' => asset('img/jornada/modulo_01.png'), 'href' => url('/modulo1'), 'title' => 'Módulo 1'],
        2 => ['bg' => 'bodyModulo2', 'img' => asset('img/jornada/modulo_02.png'), 'href' => url('/modulo2'), 'title' => 'Módulo 2'],
        3 => ['bg' => 'bodyModulo3', 'img' => asset('img/jornada/modulo_03.png'), 'href' => url('/modulo3'), 'title' => 'Módulo 3'],
        4 => ['bg' => 'bodyModulo4', 'img' => asset('img/jornada/modulo_04.png'), 'href' => url('/modulo4'), 'title' => 'Módulo 4'],
        5 => ['bg' => 'bodyModulo5', 'img' => asset('img/jornada/modulo_05.png'), 'href' => url('/modulo5'), 'title' => 'Módulo 5'],
    ];
@endphp

<div class="m-b-40">
    <section class="home-hero home-hero--light">
        <div class="home-hero__content">
            <h2 class="home-hero__title">
                Trilha do Conhecimento
            </h2>
            {{-- MELHORIA: Texto de introdução reescrito para maior clareza --}}
            <p class="home-hero__subtitle">
                Bem-vindo(a)! Esta jornada foi desenhada para aprofundar sua <strong>Percepção de Risco</strong> e fortalecer nossa cultura de segurança de forma interativa e dinâmica.
            </p>

            {{-- MELHORIA: Seção de informações importantes com mais destaque e ícones --}}
            <div class="hero-info-box">
                <ul class="hero-info-list">
                    <li><i class="fas fa-calendar-alt"></i> <strong>Liberação dos Módulos:</strong> <p>Um novo módulo será liberado por dia, a partir de <strong>18/08, às 08:00</strong>.</p></li>
                    <li><i class="fas fa-history"></i> <strong>Acesso Contínuo:</strong> Fique tranquilo(a), os módulos anteriores continuarão sempre disponíveis para consulta.</li>
                </ul>
            </div>

            <p class="home-hero__closing-text">
                Prepare-se para uma experiência de aprendizado transformadora. Vamos juntos construir um ambiente de trabalho cada vez mais seguro!
            </p>
        </div>

        <div class="home-hero__media">
            <img src="{{ asset('img/12.png') }}" alt="Ilustração de segurança no trabalho">
        </div>
    </section>

    {{-- MELHORIA: Adicionado um título de seção para criar uma transição suave para os cards --}}
    <div class="section-title-container">
        <h3 class="section-title">Explore os Módulos</h3>
        <p class="section-subtitle">Clique no módulo disponível para iniciar sua jornada de aprendizado.</p>
    </div>

    <div class="ag-courses_grid">
        @foreach ($mods as $i => $m)
            @php
                $locked    = $i > $releasedCount;
                $releaseAt = $start->copy()->addDays($i - 1);
            @endphp

            <div class="ag-courses_item {{ $m['bg'] }}">
                <a class="ag-courses-item_link mod-link {{ $locked ? 'mod-locked' : 'mod-open' }}"
                   @unless($locked) href="{{ $m['href'] }}" @endunless
                   @if($locked) aria-disabled="true" tabindex="-1" @endif>

                    {{-- chips (canto superior) --}}
                    <div class="mod-top">
                         @if($locked)
                         @endif
                    </div>

                    {{-- conteúdo (sua imagem) --}}
                    <div class="ag-courses-item_content mod-content">
                        <img src="{{ $m['img'] }}" class="img-fluid mod-image" alt="{{ $m['title'] }}">
                    </div>

                    {{-- overlay quando bloqueado --}}
                    @if ($locked)
                        <div class="mod-overlay">
                            <div class="mod-overlay__content">
                                <i class="fa fa-lock mod-lock"></i>
                                <div class="mod-when">
                                    Disponível em<br>
                                    <strong>{{ $releaseAt->format('d/m') }} às {{ $releaseAt->format('H:i') }}</strong>
                                </div>
                            </div>
                        </div>
                    @endif
                </a>
            </div>
        @endforeach
    </div>
</div>

<style>
    /* ESTILO PARA A NOVA SEÇÃO DE INTRODUÇÃO */
    .home-leadership-intro {
        text-align: center;
        max-width: 800px;
        margin: 40px auto 30px; /* Ajuste de margem para espaçamento */
    }

    .home-leadership-intro__title {
        font-size: 26px;
        font-weight: 900;
        color: var(--text, #1f2430);
        margin-bottom: 8px;
    }

    .home-leadership-intro__text {
        font-size: 16px;
        color: var(--muted, #5b6372);
        line-height: 1.6;
    }

    .home-videos {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
    }

    @media (max-width: 768px) {
        .home-videos {
            grid-template-columns: 1fr;
        }
    }

    .home-video {
        background: #f7f9ff;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, .08);
    }

    .home-video__title {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 10px;
    }

    #home {
        --text: #1f2430;
        --muted: #5b6372;
        --accent: #1691ff;
        --brand: #07509D;
    }

    /* HERO base */
    .home-hero {
        position: relative;
        display: grid;
        grid-template-columns: 1fr 1fr; /* Alterado para colunas iguais */
        gap: 30px; /* Aumentado o espaçamento */
        align-items: center;
        padding: 20px;
        border-radius: 24px;
        overflow: hidden;
        margin-bottom: 26px;
    }

    .home-hero__content {
        position: relative;
        z-index: 1;
        padding: 8px;
    }

    /* NOVO: Estilos para a imagem do hero */
    .home-hero__media {
        position: relative;
        z-index: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: -20px; /* Adiciona a borda negativa */
        overflow: hidden; /* Garante que a imagem não vaze para fora */
    }

    .home-hero__media img {
        max-width: 100%;
        height: auto;
        object-fit: contain;
    }

    /* HERO claro (tom de branco) */
    .home-hero--light {
        background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
        border: 1px solid #e9edf6;
        box-shadow: 0 10px 26px rgba(0, 0, 0, .06);
        color: var(--text);
    }

    .home-hero--light .home-hero__title span {
        color: var(--brand);
    }

    .home-hero__title {
        margin: 2px 0 10px;
        font-size: 36px;
        font-weight: 900;
        line-height: 1.15;
    }

    .home-hero__subtitle {
        margin: 0 0 18px;
        color: var(--muted);
        max-width: 55ch;
        font-size: 16px;
        line-height: 1.6;
    }
    
    /* NOVO: Estilos para o box de informações e texto de encerramento */
    .hero-info-box {
        background-color: #f0f4fa;
        border-left: 4px solid var(--brand, #07509D);
        padding: 14px 18px;
        border-radius: 8px;
        margin: 20px 0;
    }

    .hero-info-list {
        list-style: none;
        padding: 0;
        margin: 0;
        font-size: 14px;
        color: var(--muted, #5b6372);
    }

    .hero-info-list li {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .hero-info-list li:not(:last-child) {
        margin-bottom: 10px;
    }

    .hero-info-list i {
        color: var(--brand, #07509D);
        font-size: 16px;
    }

    .home-hero__closing-text {
        font-size: 15px;
        color: var(--muted);
        margin-top: 18px;
        margin-bottom: 0;
        line-height: 1.6;
    }

    /* NOVO: Estilos para o título da seção de módulos */
    .section-title-container {
        text-align: center;
        margin: 40px auto 35px;
        max-width: 600px;
    }
    .section-title {
        font-size: 28px;
        font-weight: 900;
        color: var(--text, #1f2430);
        margin-bottom: 4px;
    }
    .section-subtitle {
        font-size: 16px;
        color: var(--muted, #5b6372);
        line-height: 1.5;
    }


    /* CARDS DE AÇÃO (grid) */
    .home-cards {
        --gap: 18px;
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: var(--gap);
    }

    @media (max-width: 1200px) {
        .home-cards {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 640px) {
        .home-cards {
            grid-template-columns: 1fr;
        }
    }

    /* Responsivo do hero */
    @media (max-width: 992px) {
        .home-hero {
            grid-template-columns: 1fr;
            text-align: center; /* Centraliza o texto no mobile */
        }

        .home-hero__subtitle {
            max-width: unset;
        }

        .home-hero__chips, .home-hero__cta {
            justify-content: center; /* Centraliza chips e botões */
        }

        .home-hero__media {
            margin-top: 20px;
        }
        
        .hero-info-list li {
            text-align: left; /* Alinha o texto da lista à esquerda no mobile para legibilidade */
        }
    }
</style>

{{-- ===== Estilos isolados (não alteram seu CSS) ===== --}}
<style>
    /* O container .ag-courses_grid e .ag-courses_item já existem no seu CSS.
       Aqui só estendemos o interior com prefixo .mod-* para evitar conflitos. */

    /* link ocupa todo o card */
    .mod-link {
        position: relative;
        display: block;
        width: 100%;
        height: 100%;
        border-radius: 20px; /* mesmo raio do .ag-courses_item */
        overflow: hidden;
        text-decoration: none;
    }

    /* “chips” no topo */
    .mod-top {
        position: absolute;
        top: 10px;
        left: 10px;
        right: 10px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 8px;
        pointer-events: none;
    }

    .mod-chip {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 999px;
        background: rgba(0, 0, 0, .28);
        color: #fff;
        font-weight: 800;
        font-size: 12px;
        box-shadow: inset 0 0 0 1px rgba(255, 255, 255, .08);
        backdrop-filter: blur(2px);
    }

    .chip-open {
        background: rgba(0, 128, 0, .35);
    }

    .chip-locked {
        background: rgba(0, 0, 0, .45);
    }

    /* conteúdo central */
    .mod-content {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100%;
    }

    .mod-image {
        width: 100%;
        height: auto;
        max-width: 500px;
    }

    /* overlay de bloqueio */
    .mod-locked .mod-image {
        filter: grayscale(100%) saturate(80%) brightness(92%);
        opacity: .8;
    }

    .mod-overlay {
        position: absolute;
        inset: 0;
        border-radius: 20px;
        background: linear-gradient(180deg, rgba(20, 20, 20, .25), rgba(20, 20, 20, .38));
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .mod-overlay__content {
        text-align: center;
        color: #fff;
        font-weight: 800;
    }

    .mod-lock {
        font-size: 38px;
        display: block;
        margin-bottom: 6px;
    }

    .mod-when {
        font-size: 14px;
        line-height: 1.2;
    }

    /* hover leve só nos liberados */
    .mod-open:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 18px rgba(0, 0, 0, .15);
    }

    /* garante que o padding interno do seu card não “encolha” a imagem */
    .ag-courses-item_content.mod-content {
        padding: 10px;
    }
</style>
@endsection