@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

<div id="modulo5">

    <h2 class="titleItems mb-3">“Pirâmide Invertida”</h2>

    @if(session('success'))
    <div class="alert alert-success text-center" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger text-center" role="alert">
        {{ session('error') }}
    </div>
    @endif

    {{-- Vídeo --}}
    <div class="row">
        <div class="col-sm-12 col-md-8 m-l-r-auto">
            <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-soft">
                <iframe
                    src="https://player.vimeo.com/video/1110186203?h=08573b182a&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
                    allow="autoplay; fullscreen; picture-in-picture; clipboard-write"
                    title="01_REGRA_PTLIBRAS"></iframe>
            </div>
            <script src="https://player.vimeo.com/api/player.js"></script>
        </div>
    </div>

    {{-- Texto alternativo --}}
    {{-- TEXTO ALTERNATIVO (DISCLOSURE) --}}
    <div class="row m-b-55 m-t-30">
        <details class="ss-disclosure">
            <summary>
                <span class="label">Clique e veja o texto alternativo do vídeo.</span>
                <span class="chev" aria-hidden="true"></span>
            </summary>

<div class="ss-disclosure-body">
  <p>Ao longo desta semana, treinamos nossa percepção para identificar riscos. Mas depois de ver um risco, qual é a melhor forma de agir? Existe uma ordem de prioridade, uma hierarquia que nos guia para a solução mais segura e eficaz.</p>

  <p>Esta é a <strong>Hierarquia de Controle de Riscos</strong>. Ela funciona como um guia, nos mostrando que devemos sempre buscar a solução no nível mais alto da pirâmide primeiro.</p>

  <p>No topo, as soluções mais fortes: podemos <strong>ELIMINAR</strong> o perigo por completo, mudando o processo? Ou podemos <strong>SUBSTITUIR</strong> um material ou equipamento por outro menos perigoso? <em>Sempre devemos começar por aqui.</em></p>

  <p>Se não for possível eliminar ou substituir, descemos um nível. Usamos a <strong>ENGENHARIA</strong> para isolar o risco, ou aplicamos <strong>CONTROLES ADMINISTRATIVOS</strong>, como procedimentos, treinamentos e sinalização.</p>

  <p>E na base da pirâmide, como nossa última linha de defesa, está o <strong>EPI</strong>. Ele não remove o perigo, mas protege você dele. Por isso, seu uso correto é sempre obrigatório e indispensável.</p>

  <p>Esta semana, afiamos nossa percepção. Agora, com a hierarquia de controles, temos o poder de agir da forma mais segura. Obrigado por se comprometer com esta jornada. A sua atitude faz toda a diferença. <strong>Cuide de você e de seus colegas.</strong> Até a próxima!</p>
</div>
        </details>
    </div>

    {{-- ESTILOS do ACORDIÃO --}}
    <style>
        /* Disclosure (substitui o acordeão) */
        .ss-disclosure {
            position: relative;
            /* evita sobreposição do vídeo */
            z-index: 2;
            border-radius: 16px;
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .08);
            overflow: clip;
        }

        .ss-disclosure[open] {
            box-shadow: 0 14px 32px rgba(0, 0, 0, .12);
        }

        .ss-disclosure>summary {
            list-style: none;
            /* remove marcador do summary */
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            cursor: pointer;
            padding: 14px 18px;
            font-weight: 800;
            letter-spacing: .2px;
            color: #1f2430;
            background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
            border-radius: 16px;
            outline: none;
            user-select: none;
        }

        .ss-disclosure>summary::-webkit-details-marker {
            display: none;
        }

        .ss-disclosure .chev::before {
            content: "▾";
            display: inline-block;
            transform: rotate(-90deg);
            transition: transform .2s ease;
            font-size: 14px;
            color: #07509D;
        }

        /* Estado aberto */
        .ss-disclosure[open]>summary {
            color: #07509D;
            background: linear-gradient(180deg, #f3f8ff 0%, #eef5ff 100%);
            border-bottom: 1px solid rgba(7, 80, 157, .12);
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .ss-disclosure[open] .chev::before {
            transform: rotate(0deg);
        }

        .ss-disclosure-body {
            padding: 16px 18px 18px;
            line-height: 1.6;
            color: #2b2f3a;
            background: #fff;
            border-bottom-left-radius: 16px;
            border-bottom-right-radius: 16px;
        }

        .ss-disclosure-body p {
            margin: 0 0 10px;
        }

        .ss-disclosure-body p:last-child {
            margin-bottom: 0;
        }
    </style>

    {{-- Conteúdo do módulo (mantido) --}}
    <div class="ss-hoc mt-3">

        <div class="ss-hoc-intro">
            Bem-vindo(a) ao <strong>Módulo 5</strong>, o nosso último módulo. <br>
            Aqui vamos mostrar uma abordagem focada em controlar os riscos que identificamos em nosso ambiente...
        </div>

        <h5 class="ss-hoc-title">
            <span class="ss-dot"></span>
            Hierarquia de Controle de Riscos (da mais eficaz → menos eficaz)
        </h5>

        <div class="ss-hoc-grid">

            <div class="ss-hoc-card ss-level-1">
                <div class="ss-hoc-head">
                    <span class="ss-chip">Nível 1</span>
                    <h6 class="ss-hoc-card-title">Eliminação</h6>
                </div>
                <p class="mb-2">
                    A solução perfeita: remover completamente o perigo.
                </p>
                <p class="mb-0"><em>Exemplo:</em> Usar cabo extensor... </p>
            </div>

            <div class="ss-hoc-card ss-level-2">
                <div class="ss-hoc-head">
                    <span class="ss-chip">Nível 2</span>
                    <h6 class="ss-hoc-card-title">Substituição</h6>
                </div>
                <p class="mb-0">
                    Trocar algo perigoso por menos perigoso...
                </p>
            </div>

            <div class="ss-hoc-card ss-level-3">
                <div class="ss-hoc-head">
                    <span class="ss-chip">Nível 3</span>
                    <h6 class="ss-hoc-card-title">Controles de Engenharia</h6>
                </div>
                <p class="mb-0">
                    Criar barreiras físicas...
                </p>
            </div>

            <div class="ss-hoc-card ss-level-4">
                <div class="ss-hoc-head">
                    <span class="ss-chip">Nível 4</span>
                    <h6 class="ss-hoc-card-title">Controles Administrativos</h6>
                </div>
                <p class="mb-0">
                    Regras, procedimentos e treinamentos...
                </p>
            </div>

            <div class="ss-hoc-card ss-level-5">
                <div class="ss-hoc-head">
                    <span class="ss-chip">Nível 5</span>
                    <h6 class="ss-hoc-card-title">EPI</h6>
                </div>
                <p class="mb-0">
                    Equipamento de proteção individual como última linha...
                </p>
            </div>

        </div>

        <div class="ss-hoc-highlight">
            <div class="ss-hoc-highlight-icon"><i class="fa fa-flag-checkered"></i></div>
            <div><strong>Princípio fundamental:</strong> Sempre pensar "de cima para baixo"... </div>
        </div>
    </div>

    <style>
        /* ===== Hierarquia de Controles (estilo local) ===== */
        .ss-hoc {
            --c1: #0f8d85;
            --c2: #0a6f6d;
            --line: rgba(0, 0, 0, .08);
            --txt: #1f2430;
        }

        .ss-hoc-intro {
            background: #fff;
            color: var(--txt);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 12px 14px;
            box-shadow: 0 6px 16px rgba(0, 0, 0, .06);
            margin-bottom: 14px;
        }

        .ss-hoc-title {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 800;
            color: #07509D;
            margin: 8px 0 12px;
        }

        .ss-hoc-title .ss-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #07509D;
            display: inline-block;
        }

        .ss-hoc-grid {
            display: grid;
            gap: 14px;
            grid-template-columns: 1fr;
        }

        @media (min-width:768px) {
            .ss-hoc-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (min-width:1200px) {
            .ss-hoc-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        .ss-hoc-card {
            position: relative;
            background: #fff;
            color: var(--txt);
            border: 1px solid var(--line);
            border-radius: 14px;
            overflow: hidden;
            box-shadow: 0 8px 20px rgba(0, 0, 0, .06);
            padding: 14px;
            transition: transform .15s ease, box-shadow .15s ease;
        }

        .ss-hoc-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 26px rgba(0, 0, 0, .12);
        }

        .ss-hoc-head {
            display: flex;
            align-items: center;
            gap: 10px;
            padding-bottom: 10px;
            margin-bottom: 10px;
            border-bottom: 1px dashed var(--line);
        }

        .ss-chip {
            background: linear-gradient(135deg, #43aaa0, #0f8d85);
            color: #fff;
            font-weight: 800;
            font-size: 11px;
            letter-spacing: .2px;
            padding: 4px 10px;
            border-radius: 999px;
            white-space: nowrap;
            box-shadow: 0 4px 10px rgba(15, 141, 133, .28);
        }

        .ss-hoc-card-title {
            margin: 0;
            font-weight: 800;
        }

        .ss-hoc-highlight {
            margin-top: 14px;
            display: flex;
            gap: 12px;
            align-items: flex-start;
            background: linear-gradient(180deg, #fff, #f7fbfb);
            border: 1px solid rgba(15, 141, 133, .2);
            border-left: 4px solid #0f8d85;
            border-radius: 12px;
            padding: 12px 14px;
            color: var(--txt);
        }

        .ss-hoc-highlight-icon {
            flex: 0 0 40px;
            width: 40px;
            height: 40px;
            display: grid;
            place-items: center;
            background: linear-gradient(135deg, #43aaa0, #0f8d85);
            color: #fff;
            border-radius: 12px;
            font-size: 18px;
        }

        /* Sutilezas por nível (barra lateral decorativa) */
        .ss-level-1::before,
        .ss-level-2::before,
        .ss-level-3::before,
        .ss-level-4::before,
        .ss-level-5::before {
            content: "";
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 6px;
        }

        .ss-level-1::before {
            background: #0f8d85;
        }

        .ss-level-2::before {
            background: #149783;
        }

        .ss-level-3::before {
            background: #18a581;
        }

        .ss-level-4::before {
            background: #21b58c;
        }

        .ss-level-5::before {
            background: #3cc2a6;
        }

        /* Compatível com seu .textModulo */
        .textModulo .ss-hoc {
            color: inherit;
        }
    </style>

{{-- ===== Ação / Botões ===== --}}
    <div class="row">
        <div class="col-sm-12 text-center mt-2">
            @if (Auth::user()->usu_resp_mod5 == 1)
            <div class="d-flex justify-content-center align-items-center">
                <div class="card mb-4 bodyModulo5" style="max-width:540px;">
                    <div class="card-body">
                        <h5 class="card-title text-white">Parabéns!!!</h5>
                        <p class="card-text"><small class="text-white">Você concluiu todos os desafios do sistema</small></p>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center">
                <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            </div>
            @else
            <button class="btn btn-success btn-xl btn-cta" onclick="openHierarchyGame()">
                <i class="fa fa-play me-2"></i> Iniciar Atividade
            </button>
            <br><br>
            <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            @endif
        </div>
    </div>


{{-- ===================== MODAL DO JOGO DA HIERARQUIA ===================== --}}
<div class="modal fade" id="modalHierarchyGame" tabindex="-1" role="dialog" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-fullscreen" role="document">
        <div class="modal-content game-ui-hierarchy">
            
            <div class="game-panel">
                
                {{-- CABEÇALHO DO JOGO --}}
                <div class="game-header">
                    <div class="header-info">
                        <span class="badge"><i class="fa fa-shield-alt me-1"></i> Hierarquia de Riscos</span>
                        <span id="progressBadge" class="badge">Cenário 1/3</span>
                        <span id="timerBadge" class="badge"><i class="fa fa-clock me-1"></i> 0s</span>
                    </div>
                    <button type="button" class="btn-close-game" onclick="closeHierarchyGame()">Responder Depois</button>
                </div>

                {{-- CORPO DO JOGO --}}
                <div class="game-body">
                    <div class="scenario-container">
                        <h5 class="scenario-title">Cenário de Risco</h5>
                        <p id="scenarioText" class="scenario-text">A carregar...</p>
                    </div>
                    
                    <div class="instruction-text">
                        Selecione a medida de controlo <strong>MAIS EFETIVA</strong> abaixo:
                    </div>

                    <div id="optionsGrid" class="options-grid">
                        {{-- Opções serão inseridas pelo JavaScript --}}
                    </div>
                </div>

                {{-- RODAPÉ DO JOGO --}}
                <div class="game-footer">
                    <div id="feedback" class="feedback-area"></div>
                    <button type="button" class="btn-next-scenario" id="nextButton" style="display: none;">
                        Próximo Cenário
                    </button>
                </div>
            </div>

        </div>
    </div>
</div>


{{-- ===================== CSS DO JOGO DA HIERARQUIA ===================== --}}
<style>
    .game-ui-hierarchy {
        --game-bg: #eef2f9;
        --panel-bg: #ffffff;
        --primary-color: #4a6de5;
        --text-color: #2c3e50;
        --text-muted: #7f8c9b;
        --border-color: #dce4f2;
        --success-color: #27ae60;
        --error-color: #c0392b;
    }
    .game-ui-hierarchy {
        background-color: var(--game-bg);
        padding: 2rem;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Roboto', sans-serif;
    }
    .game-panel {
        background-color: var(--panel-bg);
        border-radius: 16px;
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        width: 100%;
        max-width: 700px; /* Largura ajustada para 2 opções */
        height: auto;
        max-height: 95vh;
        display: flex;
        flex-direction: column;
        overflow: hidden;
    }
    .game-header {
        display: flex; justify-content: space-between; align-items: center;
        padding: 1rem 1.5rem; border-bottom: 1px solid var(--border-color);
    }
    .header-info { display: flex; gap: 0.75rem; flex-wrap: wrap; }
    .header-info .badge {
        background-color: var(--game-bg); color: var(--text-muted); font-weight: 600;
        padding: 0.5rem 1rem; border-radius: 99px;
    }
    .btn-close-game {
        background: none; border: none; font-weight: 600;
        color: var(--text-muted); cursor: pointer;
    }
    .game-body {
        padding: 1.5rem 2rem; flex-grow: 1;
        overflow-y: auto; text-align: center;
    }
    .scenario-container {
        background-color: var(--game-bg); border-radius: 12px;
        padding: 1.5rem; margin-bottom: 1.5rem;
    }
    .scenario-title { color: var(--primary-color); font-weight: 700; margin-bottom: 0.5rem; }
    .scenario-text { color: var(--text-color); font-size: 1.1rem; line-height: 1.6; margin: 0; }
    .instruction-text { color: var(--text-muted); margin-bottom: 1.5rem; font-weight: 500; }
    
    /* AJUSTE: Layout para 1 coluna, ideal para 2 opções */
    .options-grid {
        display: grid;
        grid-template-columns: 1fr;
        gap: 1rem;
        text-align: left;
        max-width: 500px; /* Limita a largura das opções */
        margin: 0 auto; /* Centra o grid */
    }
    .option-card {
        background-color: var(--panel-bg); border: 2px solid var(--border-color);
        border-radius: 12px; padding: 1.25rem; font-size: 1rem;
        cursor: pointer; transition: all 0.2s ease;
    }
    .option-card:hover {
        transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.08);
        border-color: var(--primary-color);
    }
    .option-card.selected.correct {
        background-color: #f0fff8; border-color: var(--success-color);
        color: var(--success-color); font-weight: 600;
    }
    .option-card.selected.incorrect {
        background-color: #fff2f2; border-color: var(--error-color);
        color: var(--error-color); font-weight: 600;
    }
    .options-grid.disabled .option-card:not(.selected) { opacity: 0.6; pointer-events: none; }

    .game-footer {
        padding: 1rem 2rem; background-color: var(--game-bg);
        border-top: 1px solid var(--border-color);
        display: flex; align-items: center; justify-content: space-between;
    }
    .feedback-area { font-weight: 600; min-height: 24px; text-align: left; flex-grow: 1; }
    .feedback-area.correct { color: var(--success-color); }
    .feedback-area.incorrect { color: var(--error-color); }
    .btn-next-scenario {
        background-color: var(--primary-color); color: #fff;
        border: none; border-radius: 10px; padding: 0.8rem 1.5rem;
        font-weight: 600; cursor: pointer;
    }

    @media (max-width: 768px) {
        .game-ui-hierarchy { padding: 0; }
        .game-panel { border-radius: 0; max-height: 100vh; }
        .game-footer { flex-direction: column; gap: 1rem; }
    }
</style>

{{-- ===================== SCRIPT DO JOGO DA HIERARQUIA (CORRIGIDO) ===================== --}}
<script>
    // --- Funções Globais para os botões ---
    function openHierarchyGame() {
        const modal = new bootstrap.Modal(document.getElementById('modalHierarchyGame'));
        modal.show();
    }

    function closeHierarchyGame() {
        const modal = bootstrap.Modal.getOrCreateInstance(document.getElementById('modalHierarchyGame'));
        modal.hide();
    }

    // --- Lógica Principal do Jogo ---
    document.addEventListener('DOMContentLoaded', () => {
        // IMPORTANTE: Ajuste o número do módulo na rota abaixo para corresponder ao módulo correto
        const HIERARCHY_ROUTE_POST = @json(route('modulos.jogo.store', ['modulo' => 5])); 
        const HIERARCHY_CSRF_TOKEN = @json(csrf_token());

        // AJUSTE: Apenas 3 cenários com 2 opções cada
        const scenarios = [
            {
                scenario: "Operadores inalam poeira de sílica ao cortar blocos de concreto.",
                options: [
                    { text: "Usar um sistema de corte a húmido que impede a formação de poeira.", isCorrect: true },
                    { text: "Fornecer máscaras de proteção PFF2 para os operadores.", isCorrect: false }
                ],
                explanation: "Correto! O corte a húmido (Engenharia) é mais eficaz que o EPI."
            },
            {
                scenario: "Risco de queda de objetos sobre trabalhadores que circulam debaixo de um andaime.",
                options: [
                    { text: "Instalar placas de 'Cuidado: Queda de Materiais'.", isCorrect: false },
                    { text: "Instalar um rodapé e uma rede de proteção no andaime.", isCorrect: true }
                ],
                explanation: "Exato! Isolar o perigo com uma barreira física é a medida mais segura."
            },
            {
                scenario: "Um produto químico de limpeza é corrosivo e perigoso para a pele.",
                options: [
                    { text: "Substituir o produto por um detergente não corrosivo.", isCorrect: true },
                    { text: "Exigir o uso de luvas de proteção química durante a limpeza.", isCorrect: false }
                ],
                explanation: "Perfeito! Substituir o produto perigoso elimina o risco na sua origem."
            }
        ];

        let currentScenarioIndex = 0;
        let score = 0;
        let timerInterval;
        let seconds = 0;

        const modalEl = document.getElementById('modalHierarchyGame');
        const scenarioTextEl = document.getElementById('scenarioText');
        const optionsGridEl = document.getElementById('optionsGrid');
        const progressBadgeEl = document.getElementById('progressBadge');
        const timerBadgeEl = document.getElementById('timerBadge');
        const feedbackEl = document.getElementById('feedback');
        const nextButtonEl = document.getElementById('nextButton');

        function startGame() {
            currentScenarioIndex = 0;
            score = 0;
            seconds = 0;
            feedbackEl.innerText = '';
            nextButtonEl.style.display = 'none';
            loadScenario();
            startTimer();
        }

        function loadScenario() {
            const currentScenario = scenarios[currentScenarioIndex];
            scenarioTextEl.innerText = currentScenario.scenario;
            // CORRIGIDO: Use acentos graves (`) para a template string
            progressBadgeEl.innerText = `Cenário ${currentScenarioIndex + 1}/${scenarios.length}`;
            optionsGridEl.innerHTML = '';
            optionsGridEl.classList.remove('disabled');
            feedbackEl.innerText = '';
            nextButtonEl.style.display = 'none';

            currentScenario.options.forEach(option => {
                const optionEl = document.createElement('button');
                optionEl.className = 'option-card';
                optionEl.innerText = option.text;
                optionEl.onclick = () => selectOption(optionEl, option, currentScenario);
                optionsGridEl.appendChild(optionEl);
            });
        }

        function selectOption(element, option, scenario) {
            optionsGridEl.classList.add('disabled');
            element.classList.add('selected');

            if (option.isCorrect) {
                score++;
                element.classList.add('correct');
                feedbackEl.innerText = scenario.explanation;
                feedbackEl.className = 'feedback-area correct';
            } else {
                element.classList.add('incorrect');
                feedbackEl.innerText = 'Incorreto. A opção correta foi destacada.';
                feedbackEl.className = 'feedback-area incorrect';
                
                const correctOptionText = scenario.options.find(opt => opt.isCorrect).text;
                const correctOptionEl = Array.from(optionsGridEl.children).find(child => child.innerText === correctOptionText);
                if(correctOptionEl) correctOptionEl.classList.add('correct');
            }

            if (currentScenarioIndex < scenarios.length - 1) {
                nextButtonEl.innerText = 'Próximo Cenário';
            } else {
                nextButtonEl.innerText = 'Finalizar Desafio';
            }
            nextButtonEl.style.display = 'block';
        }

        nextButtonEl.addEventListener('click', () => {
            currentScenarioIndex++;
            if (currentScenarioIndex < scenarios.length) {
                loadScenario();
            } else {
                endGame();
            }
        });

        function endGame() {
            stopTimer();
            // CORRIGIDO: Use acentos graves (`) para a template string
            feedbackEl.innerText = `Desafio concluído! Acertou ${score} de ${scenarios.length} em ${seconds}s.`;
            feedbackEl.className = 'feedback-area correct';
            nextButtonEl.style.display = 'none';
            optionsGridEl.innerHTML = '';
            
            setTimeout(() => {
                enviarConclusao(seconds, score);
            }, 2000);
        }
        
        function startTimer() {
            stopTimer();
            timerInterval = setInterval(() => {
                seconds++;
                // CORRIGIDO: Use acentos graves (`) para a template string
                timerBadgeEl.innerHTML = `<i class="fa fa-clock me-1"></i> ${seconds}s`;
            }, 1000);
        }
        function stopTimer() {
            clearInterval(timerInterval);
        }

        function enviarConclusao(tempo, acertos) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = HIERARCHY_ROUTE_POST;
            form.style.display = 'none';

            // MELHORADO: Usando acentos graves (`) para melhor legibilidade
            form.innerHTML = `
                <input type="hidden" name="_token" value="${HIERARCHY_CSRF_TOKEN}">
                <input type="hidden" name="concluido" value="1">
                <input type="hidden" name="tempo" value="${tempo}">
                <input type="hidden" name="acertos" value="${acertos}">
                <input type="hidden" name="total" value="${scenarios.length}">
            `;
            document.body.appendChild(form);
            
            // CORRIGIDO: A linha abaixo foi descomentada para ativar o envio
            form.requestSubmit ? form.requestSubmit() : form.submit();
            
            // Atraso para garantir que o envio do formulário seja iniciado
            setTimeout(closeHierarchyGame, 500);
        }

        if (modalEl) {
            modalEl.addEventListener('show.bs.modal', startGame);
            modalEl.addEventListener('hide.bs.modal', stopTimer);
        }
    });
</script>
@endsection