@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

<div id="modulo3">

    <h2 class="titleItems mb-3">NR 12 - Sua Aliada na Proteção</h2>

    @if(session('success'))
    <div class="alert alert-success text-center" role="alert">
        {{ session('success') }}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center" role="alert">
        {{ session('error') }}
    </div>
    @endif

    {{-- Vídeo --}}
    <div class="row">
        <div class="col-sm-12 col-md-8 m-l-r-auto">
            <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-soft">
                <iframe
                    src="https://player.vimeo.com/video/1110185971?h=f5e3fc4dc3&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
                    allow="autoplay; fullscreen; picture-in-picture; clipboard-write"
                    title="01_REGRA_PTLIBRAS"></iframe>
            </div>
            <script src="https://player.vimeo.com/api/player.js"></script>
        </div>
    </div>

    {{-- Texto alternativo do vídeo (mantido) --}}
    {{-- TEXTO ALTERNATIVO (DISCLOSURE) --}}
    <div class="row m-b-55 m-t-30">
        <details class="ss-disclosure">
            <summary>
                <span class="label">Clique e veja o texto alternativo do vídeo.</span>
                <span class="chev" aria-hidden="true"></span>
            </summary>

            <div class="ss-disclosure-body">
                <p>Cada veículo produzido nasce da perfeita sincronia entre pessoas e máquinas. A <strong>NR&nbsp;12</strong> é a inteligência que garante que essa união seja sempre segura.</p>

                <p>A NR&nbsp;12 define o funcionamento das proteções, desde as barreiras físicas mais robustas até os sensores eletrônicos mais modernos. Ela é o padrão que transforma a nossa tecnologia em cuidado.</p>

                <p>Mas essa tecnologia de ponta depende da sua <strong>percepção</strong> para ser 100% eficaz. Antes de começar, faça a sua parte. Pergunte a si mesmo:</p>
                <ul>
                    <li>As proteções estão no lugar e funcionando?</li>
                    <li>Os sensores estão livres?</li>
                    <li>A parada de emergência está acessível?</li>
                </ul>

                <p>Lembre-se sempre: <strong>burlar, amarrar ou ignorar</strong> um dispositivo de segurança é criar um risco inaceitável para você e para toda a equipe. Qualquer anormalidade, por menor que seja, deve ser comunicada <strong>imediatamente</strong>.</p>

                <p><strong>Máquinas seguras</strong> são a nossa base. <strong>Colaboradores conscientes</strong> são a nossa maior força. Opere com conhecimento, opere com segurança.</p>
                <p><em>Cuide de você e da sua equipe! Até a próxima!</em></p>
            </div>
        </details>
    </div>

    {{-- ESTILOS do ACORDIÃO --}}
    <style>
        /* Disclosure (substitui o acordeão) */
        .ss-disclosure {
            position: relative;
            /* evita sobreposição do vídeo */
            z-index: 2;
            border-radius: 16px;
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .08);
            overflow: clip;
        }

        .ss-disclosure[open] {
            box-shadow: 0 14px 32px rgba(0, 0, 0, .12);
        }

        .ss-disclosure>summary {
            list-style: none;
            /* remove marcador do summary */
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            cursor: pointer;
            padding: 14px 18px;
            font-weight: 800;
            letter-spacing: .2px;
            color: #1f2430;
            background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
            border-radius: 16px;
            outline: none;
            user-select: none;
        }

        .ss-disclosure>summary::-webkit-details-marker {
            display: none;
        }

        .ss-disclosure .chev::before {
            content: "▾";
            display: inline-block;
            transform: rotate(-90deg);
            transition: transform .2s ease;
            font-size: 14px;
            color: #07509D;
        }

        /* Estado aberto */
        .ss-disclosure[open]>summary {
            color: #07509D;
            background: linear-gradient(180deg, #f3f8ff 0%, #eef5ff 100%);
            border-bottom: 1px solid rgba(7, 80, 157, .12);
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .ss-disclosure[open] .chev::before {
            transform: rotate(0deg);
        }

        .ss-disclosure-body {
            padding: 16px 18px 18px;
            line-height: 1.6;
            color: #2b2f3a;
            background: #fff;
            border-bottom-left-radius: 16px;
            border-bottom-right-radius: 16px;
        }

        .ss-disclosure-body p {
            margin: 0 0 10px;
        }

        .ss-disclosure-body p:last-child {
            margin-bottom: 0;
        }
    </style>
    {{-- Texto do módulo (mantido) --}}
    <div class="ss-nr12 mt-4">

        <!-- Intro -->
        <div class="ss-intro-group">
            <p class="ss-intro">
                Vamos falar sobre a <strong>NR 12 - Segurança no Trabalho em Máquinas e Equipamentos</strong>!
            </p>
            <p class="ss-intro">
                Pense nas máquinas e robôs da nossa fábrica como carros de corrida: eles são extremamente potentes, rápidos e eficientes.
            </p>
            <p class="ss-intro">
                A NR 12 é a norma que estabelece regras de segurança para máquinas e equipamentos industriais, funcionando como um “cinto de segurança” que protege os trabalhadores dos riscos operacionais.
            </p>
        </div>

        <!-- Cards -->
        <div class="ss-grid">
            <!-- Proteções Físicas -->
            <div class="ss-card ss-cta-1">
                <div class="ss-card-head">
                    <div class="ss-card-icon"><i class="fa fa-shield-alt"></i></div>
                    <h5 class="ss-card-title">Proteções Físicas</h5>
                </div>
                <div class="ss-card-body">
                    <p class="mb-2">
                        Barreiras visíveis como cercas, portões e caixas de acrílico que impedem o contato com partes perigosas da máquina.
                    </p>
                    <div class="ss-rule">
                        <i class="fa fa-exclamation-triangle me-2"></i>
                        <p><strong>Regra fundamental:</strong> se estiverem abertas ou removidas, a máquina <u>não deve</u> funcionar.</p>
                    </div>
                </div>
            </div>

            <!-- Proteções Inteligentes -->
            <div class="ss-card ss-cta-2">
                <div class="ss-card-head">
                    <div class="ss-card-icon"><i class="fa fa-microchip"></i></div>
                    <h5 class="ss-card-title">Proteções “Inteligentes”</h5>
                </div>
                <div class="ss-card-body">
                    <p class="mb-2">Sistemas automatizados de segurança que incluem:</p>
                    <ul class="ss-list">
                        <li><strong>Cortinas de luz:</strong> param a máquina se algo cruzar o feixe</li>
                        <li><strong>Sensores de porta:</strong> interrompem o funcionamento se uma proteção for aberta</li>
                        <li><strong>Botões de emergência:</strong> permitem parada imediata em situações de perigo</li>
                    </ul>
                </div>
            </div>

            <!-- Responsabilidades do trabalhador -->
            <div class="ss-card ss-cta-3">
                <div class="ss-card-head">
                    <div class="ss-card-icon"><i class="fa fa-user-check"></i></div>
                    <h5 class="ss-card-title">Responsabilidades do trabalhador</h5>
                </div>
                <div class="ss-card-body">
                    <ul class="ss-list">
                        <li>Fazer checagem visual das proteções antes de iniciar o trabalho</li>
                        <li><strong>NUNCA</strong> burlar ou desativar dispositivos de segurança</li>
                        <li>Comunicar imediatamente qualquer falha ou problema identificado ao líder</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Mensagem central -->
        <div class="ss-highlight mt-3">
            <div class="ss-highlight-icon"><i class="fa fa-hard-hat"></i></div>
            <div class="ss-highlight-text">
                <div class="fw-bold">Mensagem central</div>
                A NR 12 coloca a segurança na máquina, mas o trabalhador deve colocar consciência na operação.
                Essa parceria garante trabalho produtivo e seguro para todos.
            </div>
        </div>

    </div>

    <style>
        /* ====== Módulo 3 – NR12 (escopo local, sem conflitar com seu CSS global) ====== */
        .ss-nr12 {
            --c-text: #23262d;
            --c-soft: #f7f8fb;
        }

        .ss-nr12 .ss-intro {
            color: var(--c-text);
            margin-bottom: .65rem;
        }

        .ss-nr12 .ss-intro-group {
            margin-bottom: .75rem;
        }

        /* Grid responsivo */
        .ss-nr12 .ss-grid {
            display: grid;
            gap: 16px;
            grid-template-columns: 1fr;
        }

        @media (min-width: 768px) {
            .ss-nr12 .ss-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (min-width: 1200px) {
            .ss-nr12 .ss-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        /* Card base */
        .ss-nr12 .ss-card {
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            border-radius: 14px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, .06);
            overflow: hidden;
            height: 100%;
            transition: transform .15s ease, box-shadow .15s ease, border-color .15s ease;
        }

        .ss-nr12 .ss-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 26px rgba(0, 0, 0, .12);
        }

        /* Cabeçalho do card */
        .ss-nr12 .ss-card-head {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 14px;
            border-bottom: 1px solid rgba(0, 0, 0, .06);
            background: linear-gradient(180deg, #fff, #fafbff);
        }

        .ss-nr12 .ss-card-icon {
            width: 38px;
            height: 38px;
            border-radius: 10px;
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 16px;
            flex: 0 0 38px;
        }

        .ss-nr12 .ss-card-title {
            margin: 0;
            font-weight: 800;
            letter-spacing: .2px;
            color: #1f2430;
        }

        /* Corpo do card */
        .ss-nr12 .ss-card-body {
            padding: 14px;
            font-size: 15px;
            color: var(--c-text);
        }

        .ss-nr12 .ss-list {
            margin: .4rem 0 0 1rem;
        }

        .ss-nr12 .ss-list li {
            margin-bottom: .35rem;
        }

        /* Regra fundamental */
        .ss-nr12 .ss-rule {
            margin-top: .6rem;
            display: flex;
            align-items: flex-start;
            gap: 6px;
            padding: 10px 12px;
            border-radius: 12px;
            background: #fff7e6;
            color: #7a4a00;
            border: 1px solid #ffd48a;
            font-size: 14px;
            line-height: 1.35;
        }

        /* Destaque final */
        .ss-nr12 .ss-highlight {
            display: flex;
            gap: 12px;
            align-items: flex-start;
            background: linear-gradient(180deg, #fff, #f9fbff);
            border: 1px solid rgba(7, 80, 157, .15);
            border-left: 4px solid #07509D;
            border-radius: 12px;
            padding: 12px 14px;
        }

        .ss-nr12 .ss-highlight-icon {
            flex: 0 0 38px;
            width: 38px;
            height: 38px;
            display: grid;
            place-items: center;
            background: #243782;
            color: #fff;
            border-radius: 10px;
            font-size: 18px;
        }

        .ss-nr12 .ss-highlight-text {
            color: #1f2430;
            font-size: 15px;
        }

        /* Identidade visual (cores por card) – alinhado à paleta já usada */
        .ss-nr12 .ss-cta-1 .ss-card-icon {
            background: #243782;
        }

        /* físicas */
        .ss-nr12 .ss-cta-2 .ss-card-icon {
            background: #43aaa0;
        }

        /* inteligentes */
        .ss-nr12 .ss-cta-3 .ss-card-icon {
            background: #e94e24;
        }

        /* responsabilidades */
    </style>

    {{-- Ação --}}
    <div class="row">
        <div class="col-sm-12 text-center mt-2">
            @if (Auth::user()->usu_resp_mod3 == 1)
            <div class="d-flex justify-content-center align-items-center">
                <div class="card mb-4 bodyModulo3" style="max-width:540px;">
                    <div class="card-body">
                        <h5 class="card-title text-white">Parabéns!!!</h5>
                        <p class="card-text text-white">Você finalizou a regra de ouro número 5.</p>
                        <p class="card-text"><small class="text-white">Mas ainda não acabou, continue utilizando o game para pontuar</small></p>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center">
                <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            </div>
            @else
            <button class="btn btn-success btn-xl btn-cta" onclick="openGameModal()">
                <i class="fa fa-play me-2"></i> Iniciar Atividade
            </button>
            <br><br>
            <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            @endif
        </div>
    </div>

</div>

{{-- ===================== MODAL DO JOGO ===================== --}}
<div class="modal fade" id="modalQuestao4" tabindex="-1" role="dialog" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-fullscreen w-full h-full" role="document">
        <div class="modal-content game-modal bodyModulo3">

            <div class="modal-header border-0 flex-column text-center text-white pt-4">
                <div class="d-flex align-items-center justify-content-center gap-2 flex-wrap mb-2">
                    <span class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-brain me-1"></i> JOGO DA MEMÓRIA
                    </span>
                    <span id="tempoBadge" class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-clock me-1"></i> 0:00
                    </span>
                    <span id="progressoBadge" class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-check-double me-1"></i> 0/5
                    </span>
                </div>
                <div id="resultado" class="w-100 mt-2 fw-bold" style="min-height:24px;" aria-live="polite"></div>
                <button type="button" class="btn btn-warning btn-sm mt-2 btn-pill" onclick="sair()">Responder Depois</button>
            </div>

            <div class="pb-4 d-flex justify-content-center">
                <section class="memory-game">
                    {{-- 5 pares = 10 cartas --}}
                    <div class="memory-card" data-framework="card1">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/1.png') }}" alt="Capacete" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                    <div class="memory-card" data-framework="card1">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/2.png') }}" alt="Capacete" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>

                    <div class="memory-card" data-framework="card2">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/3.png') }}" alt="Protetor Auricular" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                    <div class="memory-card" data-framework="card2">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/4.png') }}" alt="Protetor Auricular" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>

                    <div class="memory-card" data-framework="card3">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/5.png') }}" alt="Cinto de Segurança" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                    <div class="memory-card" data-framework="card3">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/6.png') }}" alt="Cinto de Segurança" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>

                    <div class="memory-card" data-framework="card4">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/7.png') }}" alt="Óculos" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                    <div class="memory-card" data-framework="card4">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/8.png') }}" alt="Óculos" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>

                    <div class="memory-card" data-framework="card5">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/9.png') }}" alt="Outro EPI" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                    <div class="memory-card" data-framework="card5">
                        <img class="front-face" src="{{ asset('img/modulos/modulo4/10.png') }}" alt="Outro EPI" />
                        <img class="back-face" src="{{ asset('img/modulos/modulo4/capa.png') }}" alt="Capa" />
                    </div>
                </section>
            </div>

        </div>
    </div>
</div>

{{-- ===================== ESTILOS ===================== --}}
<style>
    /* ===== Jogo da Memória (Módulo 4) – FIX VISUAL ===== */

    /* grade */
    .memory-game {
        width: 85%;
        margin: 0 auto 12px;
        display: grid;
        grid-template-columns: repeat(5, minmax(120px, 1fr));
        gap: 22px;
        perspective: 1200px;
    }

    /* cada carta */
    .memory-card {
        position: relative;
        /* >>> dá altura ao card <<< */
        aspect-ratio: 1 / 1;
        /* moderno: mantém quadrado */
        min-width: 120px;

        border-radius: 18px;
        background: rgba(255, 255, 255, .05);
        box-shadow: 0 14px 30px rgba(0, 0, 0, .25), 0 3px 9px rgba(0, 0, 0, .12);
        overflow: hidden;
        cursor: pointer;
        transform-style: preserve-3d;
        transition: transform .15s ease;
    }

    .memory-card:active {
        transform: scale(.98);
    }

    /* fallback para quem NÃO suporta aspect-ratio */
    @supports not (aspect-ratio: 1 / 1) {
        .memory-card {
            height: 0;
            padding-bottom: 100%;
            /* 1:1 */
        }

        .memory-card>* {
            position: absolute;
            inset: 0;
        }
    }

    /* faces */
    .memory-card .front-face,
    .memory-card .back-face {
        position: absolute;
        inset: 0;
        display: block;
        width: 100%;
        height: 100%;
        border-radius: 16px;
        object-fit: cover;
        backface-visibility: hidden;
        -webkit-backface-visibility: hidden;
        transform-style: preserve-3d;
        transition: transform .45s ease;
    }

    /* estado inicial: mostra o verso */
    .memory-card .back-face {
        transform: rotateY(0deg);
    }

    /* frente começa “de costas” */
    .memory-card .front-face {
        transform: rotateY(180deg);
    }

    /* vira o card trocando faces */
    .memory-card.flip .back-face {
        transform: rotateY(180deg);
    }

    .memory-card.flip .front-face {
        transform: rotateY(0deg);
    }

    /* responsivo */
    @media (max-width: 1200px) {
        .memory-game {
            grid-template-columns: repeat(4, minmax(100px, 1fr));
        }
    }

    @media (max-width: 768px) {
        .memory-game {
            width: 95%;
            grid-template-columns: repeat(3, minmax(92px, 1fr));
            gap: 14px;
        }
    }
</style>

{{-- ===================== SCRIPT ===================== --}}
<script>
    // ===== Rotas/Segurança =====
    const ROUTE_POST = @json(route('modulos.jogo.store', ['modulo' => 3]));
    const CSRF_TOKEN = @json(csrf_token());
    const TOTAL_PARES = 5;

    let hasFlippedCard = false;
    let lockBoard = false;
    let firstCard = null,
        secondCard = null;
    let matchedCards = 0;

    // Timer
    let startTime = null;
    let timerInterval = null;

    function openGameModal() {
        const el = document.getElementById('modalQuestao4');
        const modal = new bootstrap.Modal(el);
        modal.show();

        // prepara o jogo
        setTimeout(() => {
            resetState();
            initialPeek();
        }, 50);
    }

    function sair() {
        const el = document.getElementById('modalQuestao4');
        const modal = bootstrap.Modal.getOrCreateInstance(el);
        modal.hide();
        resetState(true);
    }

    function resetState(keepOrder = false) {
        hasFlippedCard = false;
        lockBoard = false;
        firstCard = null;
        secondCard = null;
        matchedCards = 0;
        stopTimer();
        startTime = null;
        updateTempoBadge(0);
        updateProgressoBadge();

        const cards = document.querySelectorAll('.memory-card');
        cards.forEach(c => c.classList.remove('flip'));
        if (!keepOrder) shuffle();
        bindClicks();
        setResultado('');
    }

    function bindClicks() {
        const cards = document.querySelectorAll('.memory-card');
        cards.forEach(card => {
            card.removeEventListener('click', flipCard);
            card.addEventListener('click', flipCard);
        });
    }

    function shuffle() {
        const cards = document.querySelectorAll('.memory-card');
        cards.forEach(card => {
            card.style.order = Math.floor(Math.random() * 100);
        });
    }

    function initialPeek() {
        const cards = document.querySelectorAll('.memory-card');
        cards.forEach(card => card.classList.add('flip'));
        setTimeout(() => cards.forEach(c => c.classList.remove('flip')), 2000);
    }

    function startTimer() {
        if (startTime) return;
        startTime = Date.now();
        timerInterval = setInterval(() => {
            updateTempoBadge(getElapsedSeconds());
        }, 1000);
    }

    function stopTimer() {
        if (timerInterval) {
            clearInterval(timerInterval);
            timerInterval = null;
        }
    }

    function getElapsedSeconds() {
        return startTime ? Math.floor((Date.now() - startTime) / 1000) : 0;
    }

    function updateTempoBadge(seconds) {
        const m = Math.floor(seconds / 60);
        const s = seconds % 60;
        const el = document.getElementById('tempoBadge');
        if (el) el.innerHTML = `<i class="fa fa-clock me-1"></i> ${m}:${s < 10 ? '0' : ''}${s}`;
    }

    function updateProgressoBadge() {
        const paresFeitos = Math.floor(matchedCards / 2);
        const el = document.getElementById('progressoBadge');
        if (el) el.innerHTML = `<i class="fa fa-check-double me-1"></i> ${paresFeitos}/${TOTAL_PARES}`;
    }

    function setResultado(txt) {
        const r = document.getElementById('resultado');
        if (r) r.innerText = txt;
    }

    function flipCard() {
        if (lockBoard) return;
        if (this === firstCard) return;

        this.classList.add('flip');

        if (!hasFlippedCard) {
            hasFlippedCard = true;
            firstCard = this;
            if (!startTime) startTimer();
            return;
        }

        secondCard = this;
        checkForMatch();
    }

    function checkForMatch() {
        const isMatch = firstCard.dataset.framework === secondCard.dataset.framework;
        isMatch ? disableCards() : unflipCards();
    }

    function disableCards() {
        firstCard.removeEventListener('click', flipCard);
        secondCard.removeEventListener('click', flipCard);
        matchedCards += 2;
        updateProgressoBadge();
        checkGameOver();
        resetBoard();
    }

    function unflipCards() {
        lockBoard = true;
        setTimeout(() => {
            firstCard.classList.remove('flip');
            secondCard.classList.remove('flip');
            resetBoard();
        }, 900);
    }

    function resetBoard() {
        [hasFlippedCard, lockBoard] = [false, false];
        [firstCard, secondCard] = [null, null];
    }

    function checkGameOver() {
        const totalCards = document.querySelectorAll('.memory-card').length;
        if (matchedCards === totalCards) {
            stopTimer();
            const elapsed = getElapsedSeconds();
            const m = Math.floor(elapsed / 60),
                s = elapsed % 60;
            const tempoFmt = `${m}:${s < 10 ? '0' : ''}${s}`;
            setTimeout(() => {
                setResultado(`Parabéns! Você terminou em ${tempoFmt}`);
                enviarConclusao(elapsed);
            }, 400);
        }
    }

    // Envia conclusão para o controller do jogo
    function enviarConclusao(segundos) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = ROUTE_POST;
        form.style.display = 'none';
        form.innerHTML = `
      <input type="hidden" name="_token" value="${CSRF_TOKEN}">
      <input type="hidden" name="concluido" value="1">
      <input type="hidden" name="tempo" value="${segundos}">
      <input type="hidden" name="acertos" value="${TOTAL_PARES}">
      <input type="hidden" name="total" value="${TOTAL_PARES}">
    `;
        document.body.appendChild(form);
        if (form.requestSubmit) form.requestSubmit();
        else form.submit();
    }
</script>

@endsection