@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

<div id="modulo2">

  <h2 class="titleItems mb-3">Principais Riscos</h2>

  @if(session('success'))
  <div class="alert alert-success text-center" role="alert">
    {{ session('success') }}
  </div>
  @endif
  @if(session('error'))
  <div class="alert alert-danger text-center" role="alert">
    {{ session('error') }}
  </div>
  @endif

  {{-- Vídeo --}}
  <div class="row">
    <div class="col-sm-12 col-md-8 m-l-r-auto">
      <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-soft">
        <iframe
          src="https://player.vimeo.com/video/1110185905?h=a26cf3ea2a&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
          allow="autoplay; fullscreen; picture-in-picture; clipboard-write"
          title="01_REGRA_PTLIBRAS"></iframe>
      </div>
      <script src="https://player.vimeo.com/api/player.js"></script>
    </div>
  </div>

  {{-- Texto alternativo do vídeo --}}
  {{-- TEXTO ALTERNATIVO (DISCLOSURE) --}}
  <div class="row m-b-55 m-t-30">
    <details class="ss-disclosure">
      <summary>
        <span class="label">Clique e veja o texto alternativo do vídeo.</span>
        <span class="chev" aria-hidden="true"></span>
      </summary>

      <div class="ss-disclosure-body">
        <p>Em nosso trabalho, existem atividades que exigem tolerância zero com erros. São 5 situações de altíssimo risco. Conhecer e respeitar cada detalhe do procedimento não é uma escolha, é um compromisso com a vida.</p>

        <p><strong>Nº 1: TRABALHO EM ALTURA.</strong> Antes de subir, a regra é clara: inspeção do cinto e conexão <strong>100% do tempo</strong> a um ponto de ancoragem seguro. Nenhum passo é dado sem a garantia de estar conectado.</p>

        <p><strong>Nº 2: ENERGIAS PERIGOSAS.</strong> Máquina parada não significa máquina segura. Antes de qualquer manutenção, é obrigatório bloquear, etiquetar e testar. Garanta sempre o estado de energia zero.</p>

        <p><strong>Nº 3: ESPAÇOS CONFINADOS.</strong> A entrada só é permitida com autorização, medição de gases e um vigia presente. Nunca entre em um espaço confinado por conta própria ou sem seguir o procedimento à risca.</p>

        <p><strong>Nº 4: MOVIMENTAÇÃO DE MÁQUINAS.</strong> Seja a pé ou dirigindo, a atenção deve ser total. Respeite as faixas, a sinalização sonora e faça sempre contato visual. A preferência é sempre da segurança.</p>

        <p><strong>Nº 5: CARGAS SUSPENSAS.</strong> A área abaixo de uma carga suspensa é uma zona proibida. Nunca, em nenhuma hipótese, passe ou permaneça sob uma carga em movimento ou suspensa.</p>

        <p>Sua atitude nestes 5 momentos define a segurança de todos. Nenhuma tarefa é mais importante que a sua vida. Na dúvida, <strong>PARE</strong> e garanta que o trabalho pode seguir seguro.</p>

        <p><em>Cuide de você e da sua equipe! Até a próxima!</em></p>
      </div>
    </details>
  </div>

  {{-- ESTILOS do ACORDIÃO --}}
  <style>
    /* Disclosure (substitui o acordeão) */
    .ss-disclosure {
      position: relative;
      /* evita sobreposição do vídeo */
      z-index: 2;
      border-radius: 16px;
      background: #fff;
      border: 1px solid rgba(0, 0, 0, .06);
      box-shadow: 0 10px 26px rgba(0, 0, 0, .08);
      overflow: clip;
    }

    .ss-disclosure[open] {
      box-shadow: 0 14px 32px rgba(0, 0, 0, .12);
    }

    .ss-disclosure>summary {
      list-style: none;
      /* remove marcador do summary */
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 12px;
      cursor: pointer;
      padding: 14px 18px;
      font-weight: 800;
      letter-spacing: .2px;
      color: #1f2430;
      background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
      border-radius: 16px;
      outline: none;
      user-select: none;
    }

    .ss-disclosure>summary::-webkit-details-marker {
      display: none;
    }

    .ss-disclosure .chev::before {
      content: "▾";
      display: inline-block;
      transform: rotate(-90deg);
      transition: transform .2s ease;
      font-size: 14px;
      color: #07509D;
    }

    /* Estado aberto */
    .ss-disclosure[open]>summary {
      color: #07509D;
      background: linear-gradient(180deg, #f3f8ff 0%, #eef5ff 100%);
      border-bottom: 1px solid rgba(7, 80, 157, .12);
      border-bottom-left-radius: 0;
      border-bottom-right-radius: 0;
    }

    .ss-disclosure[open] .chev::before {
      transform: rotate(0deg);
    }

    .ss-disclosure-body {
      padding: 16px 18px 18px;
      line-height: 1.6;
      color: #2b2f3a;
      background: #fff;
      border-bottom-left-radius: 16px;
      border-bottom-right-radius: 16px;
    }

    .ss-disclosure-body p {
      margin: 0 0 10px;
    }

    .ss-disclosure-body p:last-child {
      margin-bottom: 0;
    }
  </style>
  {{-- Texto do módulo (mantido) --}}
  <div class="ss-risk mt-4">

    <div class="ss-intro-group">
      <p class="ss-intro">
        No <strong>módulo 2</strong> falaremos sobre os <strong>Principais Riscos Críticos</strong> em nossa planta.
      </p>
      <p class="ss-intro">
        No nosso dia a dia, encontramos vários tipos de risco. Mas existem algumas atividades que são especiais,
        pois um erro nelas pode ter consequências muito sérias.
      </p>
      <p class="ss-intro">
        Precisamos dar a elas um respeito e uma atenção muito maiores.
      </p>
      <p class="ss-intro">
        São <strong>5 atividades críticas</strong> com <strong>TOLERÂNCIA ZERO</strong> para erros e improvisos:
      </p>
    </div>

    <div class="ss-grid">
      <!-- 1. Trabalho em Altura -->
      <div class="ss-card ss-cta-1">
        <div class="ss-card-head">
          <div class="ss-card-icon"><i class="fa fa-arrow-up"></i></div>
          <h5 class="ss-card-title">Trabalho em Altura</h5>
        </div>
        <div class="ss-card-body">
          <div class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> Perigo</div>
          <p class="mb-2">Quedas de qualquer altura</p>

          <div class="ss-chip action"><i class="fa fa-check me-1"></i> Atitudes corretas</div>
          <ul class="ss-list">
            <li>Verificar cinto antes do uso</li>
            <li>Prender em ponto de ancoragem seguro <strong>ANTES</strong> de iniciar</li>
            <li>Nunca se desconectar no alto</li>
          </ul>
        </div>
      </div>

      <!-- 2. Energias Perigosas (LOTO) -->
      <div class="ss-card ss-cta-2">
        <div class="ss-card-head">
          <div class="ss-card-icon"><i class="fa fa-bolt"></i></div>
          <h5 class="ss-card-title">Energias Perigosas (Bloqueio e Etiquetagem)</h5>
        </div>
        <div class="ss-card-body">
          <div class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> Perigo</div>
          <p class="mb-2">Máquina ligar sozinha durante manutenção/limpeza</p>

          <div class="ss-chip action"><i class="fa fa-check me-1"></i> Atitudes corretas</div>
          <ul class="ss-list">
            <li>Usar cadeado e etiqueta com seu nome</li>
            <li>Testar se energia está em zero</li>
            <li>Nunca remover bloqueio de outros</li>
          </ul>
        </div>
      </div>

      <!-- 3. Espaços Confinados -->
      <div class="ss-card ss-cta-3">
        <div class="ss-card-head">
          <div class="ss-card-icon"><i class="fa fa-door-closed"></i></div>
          <h5 class="ss-card-title">Espaços Confinados</h5>
        </div>
        <div class="ss-card-body">
          <div class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> Perigo</div>
          <p class="mb-2">Falta de oxigênio ou gases tóxicos (invisíveis/inodoros)</p>

          <div class="ss-chip action"><i class="fa fa-check me-1"></i> Atitudes corretas</div>
          <ul class="ss-list">
            <li>Só entrar com PT liberada</li>
            <li>Confirmar medição do ar</li>
            <li>Sempre trabalhar com vigia do lado externo</li>
          </ul>
        </div>
      </div>

      <!-- 4. Movimentação de Máquinas -->
      <div class="ss-card ss-cta-4">
        <div class="ss-card-head">
          <div class="ss-card-icon"><i class="fa fa-truck"></i></div>
          <h5 class="ss-card-title">Movimentação de Máquinas (empilhadeiras, rebocadores)</h5>
        </div>
        <div class="ss-card-body">
          <div class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> Perigo</div>
          <p class="mb-2">Atropelamento ou prensamento</p>

          <div class="ss-chip action"><i class="fa fa-check me-1"></i> Atitudes corretas</div>
          <ul class="ss-list">
            <li>Andar pelas faixas de pedestres</li>
            <li>Fazer contato visual com o operador</li>
            <li>Evitar distrações (celular)</li>
          </ul>
        </div>
      </div>

      <!-- 5. Cargas Suspensas -->
      <div class="ss-card ss-cta-5">
        <div class="ss-card-head">
          <div class="ss-card-icon"><i class="fa fa-box"></i></div>
          <h5 class="ss-card-title">Cargas Suspensas</h5>
        </div>
        <div class="ss-card-body">
          <div class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> Perigo</div>
          <p class="mb-2">Queda de materiais transportados pelo ar</p>

          <div class="ss-chip action"><i class="fa fa-check me-1"></i> Atitudes corretas</div>
          <ul class="ss-list">
            <li><strong>NUNCA</strong> ficar/passar por baixo de carga suspensa</li>
            <li>Respeitar isolamento</li>
            <li>Manter distância segura</li>
          </ul>
        </div>
      </div>
    </div><!-- ss-grid -->

    <div class="ss-highlight mt-3">
      <div class="ss-highlight-icon"><i class="fa fa-flag-checkered"></i></div>
      <div class="ss-highlight-text">
        <div class="fw-bold">Regra fundamental</div>
        Seguir procedimentos sempre, sem exceção. Em caso de dúvida, <strong>PARAR</strong> e consultar liderança.
        Nenhuma tarefa justifica arriscar vidas.
      </div>
    </div>

  </div>

  <style>
    /* ====== Módulo 2 – Principais Riscos (escopo local) ====== */
    .ss-risk {
      --c-text: #23262d;
      --c-soft: #f7f8fb;
    }

    .ss-risk .ss-intro {
      color: var(--c-text);
      margin-bottom: .6rem;
    }

    .ss-intro-group {
      margin-bottom: .5rem;
    }

    /* Grid responsivo de cards */
    .ss-risk .ss-grid {
      display: grid;
      gap: 16px;
      grid-template-columns: 1fr;
    }

    @media (min-width: 768px) {
      .ss-risk .ss-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    @media (min-width: 1200px) {
      .ss-risk .ss-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }

    /* Card base */
    .ss-risk .ss-card {
      background: #fff;
      border: 1px solid rgba(0, 0, 0, .06);
      border-radius: 14px;
      box-shadow: 0 6px 18px rgba(0, 0, 0, .05);
      overflow: hidden;
      height: 100%;
      transition: transform .15s ease, box-shadow .15s ease, border-color .15s ease;
    }

    .ss-risk .ss-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 12px 26px rgba(0, 0, 0, .12);
    }

    /* Cabeçalho do card */
    .ss-risk .ss-card-head {
      display: flex;
      align-items: center;
      gap: 10px;
      padding: 12px 14px;
      border-bottom: 1px solid rgba(0, 0, 0, .06);
      background: linear-gradient(180deg, #fff, #fafbff);
    }

    .ss-risk .ss-card-icon {
      width: 36px;
      height: 36px;
      border-radius: 10px;
      display: grid;
      place-items: center;
      color: #fff;
      font-size: 16px;
      flex: 0 0 36px;
    }

    .ss-risk .ss-card-title {
      margin: 0;
      font-weight: 800;
      letter-spacing: .2px;
      color: #1f2430;
    }

    /* Corpo do card */
    .ss-risk .ss-card-body {
      padding: 14px;
      font-size: 15px;
      color: var(--c-text);
    }

    .ss-risk .ss-list {
      margin: .4rem 0 0 .9rem;
    }

    .ss-risk .ss-list li {
      margin-bottom: .35rem;
    }

    /* Chips */
    .ss-risk .ss-chip {
      display: inline-flex;
      align-items: center;
      gap: 6px;
      font-weight: 800;
      font-size: 12px;
      letter-spacing: .2px;
      padding: 6px 10px;
      border-radius: 999px;
      color: #fff;
      margin: .2rem 0 .35rem;
    }

    .ss-risk .ss-chip.danger {
      background: #d62828;
    }

    .ss-risk .ss-chip.action {
      background: #0f7c1c;
    }

    /* Destaque final */
    .ss-risk .ss-highlight {
      display: flex;
      gap: 12px;
      align-items: flex-start;
      background: linear-gradient(180deg, #fff, #f9fbff);
      border: 1px solid rgba(7, 80, 157, .15);
      border-left: 4px solid #07509D;
      border-radius: 12px;
      padding: 12px 14px;
    }

    .ss-risk .ss-highlight-icon {
      flex: 0 0 38px;
      width: 38px;
      height: 38px;
      display: grid;
      place-items: center;
      background: #243782;
      color: #fff;
      border-radius: 10px;
      font-size: 18px;
    }

    .ss-risk .ss-highlight-text {
      color: #1f2430;
      font-size: 15px;
    }

    /* Cores dos ícones por card (para dar identidade) */
    .ss-risk .ss-cta-1 .ss-card-icon {
      background: #243782;
    }

    /* altura */
    .ss-risk .ss-cta-2 .ss-card-icon {
      background: #e94e24;
    }

    /* loto */
    .ss-risk .ss-cta-3 .ss-card-icon {
      background: #5b5c65;
    }

    /* confinado */
    .ss-risk .ss-cta-4 .ss-card-icon {
      background: #eca935;
    }

    /* movimentação */
    .ss-risk .ss-cta-5 .ss-card-icon {
      background: #43aaa0;
    }

    /* cargas */
  </style>

{{-- Ação --}}
  <div class="row">
    <div class="col-sm-12 text-center mt-2">
      @if (Auth::user()->usu_resp_mod2 == 1)
      <div class="d-flex justify-content-center align-items-center">
        <div class="card mb-4" style="max-width:540px; background-color: #e94e24;">
          <div class="card-body">
            <h5 class="card-title text-white">Parabéns!!!</h5>
            <p class="card-text text-white">Você finalizou este módulo com sucesso.</p>
            <p class="card-text"><small class="text-white">Continue na Trilha do Conhecimento para aprender ainda mais.</small></p>
          </div>
        </div>
      </div>
      <div class="d-flex justify-content-center">
        <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar à Trilha do Conhecimento</a>
      </div>
      @else
      <button class="btn btn-success btn-xl btn-cta" onclick="openGameModal()">
        <i class="fa fa-play me-2"></i> Iniciar Atividade
      </button>
      <br><br>
      <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar à Trilha do Conhecimento</a>
      @endif
    </div>
  </div>
</div>

{{-- =================================================================== --}}
{{-- =================== MODAL DO JOGO (V2 - FUNDO LARANJA / GRID DINÂMICO) ================== --}}
{{-- =================================================================== --}}
<div class="modal fade" id="matchGameModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-xl modal-fullscreen-xl-down modal-dialog-centered" role="document">
    <div class="modal-content game-modal-orange">

      {{-- CABEÇALHO DO MODAL --}}
      <div class="modal-header">
        <div class="game-header-info">
          <span class="badge">
            <i class="fa fa-link me-1"></i> LIGUE OS RISCOS
          </span>
        </div>
        <div class="game-header-stats">
          <span id="progressLabel" class="badge">
            <i class="fa fa-check-double me-1"></i> 0/4
          </span>
          <span id="timerLabel" class="badge">
            <i class="fa fa-clock me-1"></i> 0s
          </span>
        </div>
      </div>

      {{-- CORPO DO JOGO --}}
      <div class="modal-body">
        <p class="game-instruction">Clique em uma imagem e depois no texto correspondente para formar os pares.</p>
        
        {{-- NOVO LAYOUT COM GRADE ÚNICA E FLEXÍVEL --}}
        <div class="game-board" id="game-board">
          {{-- Cartões de imagem e texto serão inseridos aqui de forma mista --}}
        </div>

        {{-- Tela de Conclusão --}}
        <div class="completion-screen" id="completion-screen">
          <div class="completion-box">
            <div class="completion-icon"><i class="fa fa-check"></i></div>
            <h3 class="completion-title">Parabéns!</h3>
            <p class="completion-text">Você associou todos os riscos corretamente.</p>
            <p class="completion-time">Seu tempo: <strong id="finalTime">0s</strong></p>
          </div>
        </div>
      </div>

      {{-- RODAPÉ DO MODAL --}}
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm btn-pill" onclick="closeGameModal()">
          Responder Depois
        </button>
      </div>

    </div>
  </div>
</div>

{{-- ===================== ESTILOS GERAIS DO JOGO (V2) ===================== --}}
<style>
  :root {
    --theme-orange: #f97316; /* Laranja principal (Tailwind Orange 500) */
    --theme-orange-dark: #ea580c; /* Laranja mais escuro para hover */
    --theme-orange-light: #fff7ed; /* Laranja bem claro para fundos de badge */
    --theme-orange-bg: linear-gradient(160deg, #fff7ed 0%, #ffedd5 100%); /* NOVO: Fundo gradiente laranja */
    --theme-success: #16a34a;
    --theme-text: #4b5563;
    --theme-card-bg: #ffffff;
  }
  .btn-cta {
    box-shadow: 0 8px 20px rgba(233, 78, 36, .3);
    transition: transform .2s ease-out, box-shadow .2s ease-out;
  }
  .btn-cta:hover { transform: translateY(-3px); box-shadow: 0 12px 25px rgba(233, 78, 36, .35); }

  /* --- Estilo Base do Modal --- */
  .game-modal-orange {
    background-color: var(--theme-card-bg); /* Fundo do modal em si pode ser branco */
    border: none;
    display: flex;
    flex-direction: column;
    height: 100%;
  }
  @media (min-width: 1200px) {
    .modal-dialog.modal-fullscreen-xl-down .modal-content {
      border-radius: 1.5rem;
      box-shadow: 0 20px 50px rgba(0,0,0, .15);
      max-height: 95vh;
    }
  }

  .game-modal-orange .modal-header,
  .game-modal-orange .modal-footer {
    border: none;
    padding: 1rem 1.5rem;
    background-color: var(--theme-card-bg);
  }
  .game-modal-orange .modal-header {
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }
  .game-modal-orange .modal-footer{
    border-top: 1px solid #e5e7eb;
  }

  /* --- Cabeçalho do Jogo --- */
  .game-header-info .badge,
  .game-header-stats .badge {
    background-color: var(--theme-orange-light);
    color: var(--theme-orange-dark);
    font-size: 0.9rem;
    font-weight: 700;
    padding: .6em 1.2em;
    border-radius: 999px;
  }
  .game-header-stats { display: flex; gap: 0.75rem; }

  /* --- Corpo do Jogo --- */
  .modal-body {
    flex-grow: 1;
    position: relative;
    padding: 1.5rem;
    overflow-y: auto;
    background: var(--theme-orange-bg); /* APLICANDO O FUNDO LARANJA */
  }
  .game-instruction {
    text-align: center;
    color: var(--theme-text);
    margin-bottom: 1.5rem;
    font-weight: 500;
  }
  
  /* NOVO: Estilo da Grade Dinâmica */
/* NOVO: Estilo da Grade Dinâmica e Responsiva para Desktop */
.game-board {
  display: grid;
  gap: 1rem;
  /* Celular: 2 colunas por padrão */
  grid-template-columns: repeat(2, 1fr);
  /* Centraliza a grade quando há limite de largura */
  margin: 0 auto;
}

/* Tablet: 3 colunas */
@media (min-width: 768px) {
  .game-board {
    grid-template-columns: repeat(3, 1fr);
  }
}

/* Desktop: 4 colunas com largura máxima para melhor visualização */
@media (min-width: 992px) {
  .game-board {
    grid-template-columns: repeat(4, 1fr);
    max-width: 1100px; /* Limita a largura máxima em telas muito grandes */
  }
}
  /* --- Cartões --- */
  .match-card {
    position: relative;
    background-color: var(--theme-card-bg);
    border: 2px solid #e5e7eb;
    border-radius: 1rem;
    padding: 0.75rem;
    display: flex;
    flex-direction: column; /* Para alinhar imagem e texto se necessário */
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: transform .2s ease, box-shadow .2s ease, border-color .2s ease;
    box-shadow: 0 4px 6px -1px rgba(0,0,0,.05);
    user-select: none;
    min-height: 150px; /* Altura mínima para consistência */
  }
  .match-card:not(.matched):hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 15px -3px rgba(0,0,0,.08);
    border-color: #d1d5db;
  }
  .match-card.image-card img {
    width: 100%;
    max-width: 200px;
    height: auto;
    border-radius: 0.75rem;
    pointer-events: none;
  }
  .match-card.text-card {
    font-weight: 600;
    color: var(--theme-text);
    text-align: center;
    font-size: 0.95rem;
    line-height: 1.4;
  }

  /* --- Estados dos Cartões --- */
  .match-card.selected {
    border-color: var(--theme-orange);
    box-shadow: 0 0 0 3px var(--theme-orange-light);
    transform: translateY(-2px);
  }
  .match-card.matched {
    border-color: var(--theme-success);
    background-color: #f0fdf4;
    cursor: default;
    opacity: 0.8;
  }
  .match-card.matched::after {
    content: '\f00c'; /* Ícone de check do Font Awesome */
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
    position: absolute;
    top: 10px; right: 10px; width: 30px; height: 30px;
    background-color: var(--theme-success); color: white;
    border-radius: 50%; display: grid; place-items: center;
    font-size: 0.9rem; animation: pop-in .3s ease-out;
  }
  .match-card.shake {
    animation: shake-horizontal 0.5s cubic-bezier(.455,.030,.515,.955) both;
  }

  /* --- Tela de Conclusão --- */
  .completion-screen {
    position: absolute; inset: 0;
    background-color: rgba(255, 247, 237, 0.9); /* Fundo da tela de conclusão com tom de laranja */
    backdrop-filter: blur(5px); display: flex; align-items: center;
    justify-content: center; opacity: 0; visibility: hidden;
    transition: opacity .4s ease, visibility .4s ease; z-index: 10;
  }
  .completion-screen.visible { opacity: 1; visibility: visible; }
  .completion-box {
    background-color: var(--theme-card-bg); padding: 2.5rem;
    border-radius: 1.5rem; text-align: center;
    box-shadow: 0 20px 40px rgba(0,0,0, .1);
    transform: scale(0.9); animation: pop-in .4s ease-out forwards;
  }
  .completion-icon {
    width: 70px; height: 70px; margin: 0 auto 1rem;
    background-color: var(--theme-success); color: white;
    border-radius: 50%; display: grid; place-items: center; font-size: 2rem;
  }
  .completion-title { color: var(--theme-text); font-weight: 800; }
  .completion-text { color: #6b7280; font-size: 1.1rem; margin-bottom: 0.5rem; }
  .completion-time { font-size: 1.25rem; color: var(--theme-text); }

  /* --- Animações --- */
  @keyframes pop-in { 0% { transform: scale(0.8); opacity: 0; } 100% { transform: scale(1); opacity: 1; } }
  @keyframes shake-horizontal { 0%, 100% { transform: translateX(0); } 10%, 30%, 50%, 70%, 90% { transform: translateX(-8px); } 20%, 40%, 60%, 80% { transform: translateX(8px); } }

  /* --- Responsividade Específica para a Grade --- */
  @media (max-width: 576px) {
    .modal-body { padding: 1rem; }
    .game-board {
      /* Garante 2 colunas no celular */
      grid-template-columns: repeat(2, 1fr);
      gap: 0.75rem;
    }
    .match-card.text-card { font-size: 0.85rem; }
  }
</style>


{{-- ===================== SCRIPT (JOGO DE LIGAR ITENS V2) ===================== --}}
<script>
document.addEventListener('DOMContentLoaded', () => {

  // --- Configurações e Elementos do DOM ---
  const modalEl = document.getElementById('matchGameModal');
  const gameModal = new bootstrap.Modal(modalEl);
  const BASE_IMG_URL = @json(asset('img'));
  
  // MODIFICADO: Array agora com 4 itens
  const gameData = [
    { id: 1, img: `${BASE_IMG_URL}/modulos/modulo2/1.png`, text: 'Máquina parada não é máquina segura. Bloqueie, etiquete e teste sempre para garantir energia zero antes da manutenção.' },
    { id: 2, img: `${BASE_IMG_URL}/modulos/modulo2/4.png`, text: 'Entrada permitida apenas com autorização, medição de gases e um vigia presente do lado de fora.' },
    { id: 3, img: `${BASE_IMG_URL}/modulos/modulo2/3.png`, text: 'Inspeção do cinto e conexão 100% do tempo a um ponto de ancoragem seguro antes de subir.' },
    { id: 4, img: `${BASE_IMG_URL}/modulos/modulo2/5.png`, text: 'Atenção total ao andar ou dirigir. Respeite as faixas, a sinalização e faça sempre contato visual.' }
  ];

  // --- Objeto de Estado do Jogo ---
  let gameState = {
    timer: null, seconds: 0, selection: [],
    pairsFound: 0, isLocked: false, gameEnded: false
  };

  // --- Funções de Controle do Modal ---
  window.openGameModal = () => gameModal.show();
  window.closeGameModal = () => gameModal.hide();

  // --- Lógica Principal do Jogo ---
  function setupGame() {
    resetGameState();
    const gameBoard = document.getElementById('game-board');
    gameBoard.innerHTML = '';
    document.getElementById('completion-screen').classList.remove('visible');

    const allCards = [];
    gameData.forEach(item => {
        allCards.push({ type: 'image', id: item.id, content: item.img });
        allCards.push({ type: 'text', id: item.id, content: item.text });
    });

    const shuffledCards = allCards.map(value => ({ value, sort: Math.random() }))
                                 .sort((a, b) => a.sort - b.sort)
                                 .map(({ value }) => value);

    shuffledCards.forEach(card => {
        if (card.type === 'image') {
            gameBoard.innerHTML += `
                <div class="match-card image-card" data-id="${card.id}" data-type="image" tabindex="0">
                    <img src="${card.content}" alt="Situação de risco ${card.id}" draggable="false">
                </div>`;
        } else {
            gameBoard.innerHTML += `
                <div class="match-card text-card" data-id="${card.id}" data-type="text" tabindex="0">
                    ${card.content}
                </div>`;
        }
    });

    document.querySelectorAll('.match-card').forEach(card => {
      card.addEventListener('click', handleCardSelection);
      card.addEventListener('keypress', (e) => (e.key === 'Enter' || e.key === ' ') && handleCardSelection(e));
    });
  }

  function handleCardSelection(event) {
    const card = event.currentTarget;
    if (gameState.isLocked || card.classList.contains('selected') || card.classList.contains('matched')) return;

    if (!gameState.timer && !gameState.gameEnded) startTimer();

    card.classList.add('selected');
    gameState.selection.push(card);

    if (gameState.selection.length === 2) {
      checkForMatch();
    }
  }

  function checkForMatch() {
    gameState.isLocked = true;
    const [card1, card2] = gameState.selection;

    if (card1.dataset.type === card2.dataset.type) {
      setTimeout(() => {
        card1.classList.remove('selected');
        card2.classList.remove('selected');
        gameState.selection = [];
        gameState.isLocked = false;
      }, 500);
      return;
    }
    
    if (card1.dataset.id === card2.dataset.id) {
      handleCorrectMatch(card1, card2);
    } else {
      handleIncorrectMatch(card1, card2);
    }
  }

  function handleCorrectMatch(card1, card2) {
    gameState.pairsFound++;
    updateProgressLabel();
    card1.classList.remove('selected');
    card2.classList.remove('selected');
    card1.classList.add('matched');
    card2.classList.add('matched');
    gameState.selection = [];
    gameState.isLocked = false;
    if (gameState.pairsFound === gameData.length) {
      endGame();
    }
  }

  function handleIncorrectMatch(card1, card2) {
    card1.classList.add('shake');
    card2.classList.add('shake');
    setTimeout(() => {
      card1.classList.remove('selected', 'shake');
      card2.classList.remove('selected', 'shake');
      gameState.selection = [];
      gameState.isLocked = false;
    }, 800);
  }

  function endGame() {
    stopTimer();
    gameState.gameEnded = true;
    document.getElementById('finalTime').textContent = `${gameState.seconds}s`;
    document.getElementById('completion-screen').classList.add('visible');
    setTimeout(submitGameData, 2500);
  }

  function submitGameData() {
      const form = document.createElement('form');
      form.method = 'POST';
      form.action = @json(route('modulos.jogo.store', ['modulo' => 2]));
      form.style.display = 'none';
      form.innerHTML = `
        <input type="hidden" name="_token" value="${@json(csrf_token())}">
        <input type="hidden" name="concluido" value="1">
        <input type="hidden" name="tempo" value="${gameState.seconds}">
        <input type="hidden" name="acertos" value="${gameData.length}">
        <input type="hidden" name="total" value="${gameData.length}">
      `;
      document.body.appendChild(form);
      form.submit();
  }

  function resetGameState() {
    stopTimer();
    gameState.timer = null; gameState.seconds = 0; gameState.selection = [];
    gameState.pairsFound = 0; gameState.isLocked = false; gameState.gameEnded = false;
    updateTimerLabel(); updateProgressLabel();
  }
  
  function startTimer() {
    gameState.timer = setInterval(() => {
      gameState.seconds++;
      updateTimerLabel();
    }, 1000);
  }

  function stopTimer() {
    clearInterval(gameState.timer);
    gameState.timer = null;
  }

  const updateTimerLabel = () => {
    document.getElementById('timerLabel').innerHTML = `<i class="fa fa-clock me-1"></i> ${gameState.seconds}s`;
  };
  const updateProgressLabel = () => {
    document.getElementById('progressLabel').innerHTML = `<i class="fa fa-check-double me-1"></i> ${gameState.pairsFound}/${gameData.length}`;
  };

  modalEl.addEventListener('show.bs.modal', setupGame);
  modalEl.addEventListener('hide.bs.modal', resetGameState);

});
</script>

@endsection