@extends('layouts.main')

@section('title', 'SafetyStart - Minuto da Percepção')

@section('content')
<div id="block-master-7">
    <section class="home-hero home-hero--light">
        <div class="home-hero__content">
            <h2 class="home-hero__title">
                Minuto da Percepção
            </h2>
            
            {{-- MELHORIA: O novo texto foi inserido e reestruturado para melhor legibilidade --}}
            <p class="home-hero__subtitle">
                Este espaço foi criado para você aprimorar sua Percepção de Risco de maneira prática e contínua. Todos os dias, às 08:00, um novo vídeo será liberado com uma dica exclusiva.
            </p>

            <div class="hero-info-box">
                <h3 class="hero-info-title">Como Funciona:</h3>
                <ul class="hero-info-list">
                    <li><i class="fas fa-video"></i> <strong>Liberação de Vídeos:</strong> Um novo vídeo por dia, às 08:00, com dicas sobre percepção de risco.</li>
                    <li><i class="fas fa-star"></i> <strong>Avaliação:</strong> Após assistir, avalie o vídeo para acumular pontos e acompanhar seu progresso.</li>
                    <li><i class="fas fa-history"></i> <strong>Acesso Permanente:</strong> Não se preocupe, os vídeos anteriores estarão sempre disponíveis para consulta.</li>
                </ul>
            </div>

            <p class="home-hero__closing-text">
                Prepare-se para melhorar sua percepção e contribuir para um ambiente de trabalho mais seguro. Vamos juntos nessa jornada!
            </p>

        </div>

        <div class="home-hero__media">
            <img src="{{ asset('img/12.png') }}" alt="Ilustração de segurança no trabalho">
        </div>
    </section>

    {{-- MELHORIA: Adicionado um título de seção para criar uma transição suave para os cards --}}
    <div class="section-title-container">
        <h3 class="section-title">Acesse os Vídeos</h3>
        <p class="section-subtitle">Clique no vídeo disponível para iniciar.</p>
    </div>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @elseif (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @php
        use Carbon\Carbon;

        $tz    = 'America/Sao_Paulo';
        // AJUSTE: A data foi corrigida para 18/08, conforme o texto informativo.
        $start = Carbon::create(2025, 8, 18, 8, 0, 0, $tz);
        $now   = Carbon::now($tz);
        $releasedCount = $now->lt($start) ? 0 : min(5, $start->diffInDays($now) + 1);

        $cards = [
            ['title' => 'Perigo e Risco',                                     'href' => url('/minuto/minuto1')],
            ['title' => 'Principais Riscos: as 5 Atividades Críticas',       'href' => url('/minuto/minuto2')],
            ['title' => 'Segurança de Máquinas e Equipamentos',              'href' => url('/minuto/minuto3')],
            ['title' => 'ARPT: Análise de Risco e Permissão de Trabalho',    'href' => url('/minuto/minuto4')],
            ['title' => 'Hierarquia de Controle de Riscos',                  'href' => url('/minuto/minuto5')],
        ];
    @endphp

    <div class="ss-grid ss-grid--pill">
        @foreach ($cards as $idx => $c)
            @php
                $i         = $idx + 1;
                $locked    = $i > $releasedCount;
                $releaseAt = $start->copy()->addDays($i - 1);
                $bgClass   = "bodyModulo{$i}";
                $iconPath  = asset(sprintf('img/dia%02d.png', $i));
            @endphp

            <a class="ss-card ss-pill {{ $bgClass }} {{ $locked ? 'is-locked' : 'is-open' }}"
               @unless($locked) href="{{ $c['href'] }}" @endunless
               @if($locked) aria-disabled="true" tabindex="-1" @endif>

                <span class="ss-tint" aria-hidden="true"></span>

                <div class="ss-card-media">
                    <img src="{{ $iconPath }}" alt="Ícone Dia {{ $i }}"
                         onerror="this.src='{{ asset('img/SAFETYSTART.png') }}'">
                </div>

                <div class="ss-card-body">
                    <h3 class="ss-card-title">{{ $c['title'] }}</h3>

                    @unless($locked)
                        <span class="ss-card-cta">Assistir</span>
                    @endunless
                </div>

                @if($locked)
                    <div class="ss-lock-overlay" aria-hidden="true">
                        <div class="ss-lock-content">
                            <i class="fa fa-lock ss-lock-icon"></i>
                            <div class="ss-lock-text">
                                Disponível em<br>
                                <strong>{{ $releaseAt->format('d/m') }} às {{ $releaseAt->format('H:i') }}</strong>
                            </div>
                        </div>
                    </div>
                @endif
            </a>
        @endforeach
    </div>
</div>
<style>
    /* Estilos Gerais (sem alterações) */
    #home {
        --text: #1f2430;
        --muted: #5b6372;
        --accent: #1691ff;
        --brand: #07509D;
    }

    /* HERO base */
    .home-hero {
        position: relative;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        align-items: center;
        padding: 20px;
        border-radius: 24px;
        overflow: hidden;
        margin-bottom: 26px;
    }

    .home-hero__content {
        position: relative;
        z-index: 1;
        padding: 8px;
    }

    .home-hero__media {
        position: relative;
        z-index: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: -20px;
        overflow: hidden;
    }

    .home-hero__media img {
        max-width: 100%;
        height: auto;
        object-fit: contain;
    }

    .home-hero--light {
        background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
        border: 1px solid #e9edf6;
        box-shadow: 0 10px 26px rgba(0, 0, 0, .06);
        color: var(--text);
    }

    .home-hero--light .home-hero__title span {
        color: var(--brand);
    }

    .home-hero__title {
        margin: 2px 0 10px;
        font-size: 36px;
        font-weight: 900;
        line-height: 1.15;
    }

    .home-hero__subtitle {
        margin: 0 0 18px;
        color: var(--muted);
        max-width: 55ch;
        font-size: 16px;
        line-height: 1.6;
    }
    
    /* NOVO: Estilos para o box de informações e texto de encerramento */
    .hero-info-box {
        background-color: #f0f4fa;
        border-left: 4px solid var(--brand, #07509D);
        padding: 16px 20px;
        border-radius: 8px;
        margin: 20px 0;
    }

    /* NOVO: Título dentro da caixa de informações */
    .hero-info-title {
        font-size: 16px;
        font-weight: 900;
        color: var(--text);
        margin-top: 0;
        margin-bottom: 12px;
    }

    .hero-info-list {
        list-style: none;
        padding: 0;
        margin: 0;
        font-size: 14px;
        color: var(--muted, #5b6372);
    }

    .hero-info-list li {
        display: flex;
        align-items: flex-start; /* Alinha pelo topo para textos maiores */
        gap: 12px;
    }

    .hero-info-list li:not(:last-child) {
        margin-bottom: 10px;
    }

    .hero-info-list i {
        color: var(--brand, #07509D);
        font-size: 16px;
        margin-top: 2px; /* Pequeno ajuste para alinhar com o texto */
    }

    .home-hero__closing-text {
        font-size: 15px;
        color: var(--muted);
        margin-top: 18px;
        margin-bottom: 0;
        line-height: 1.6;
    }

    /* NOVO: Estilos para o título da seção de módulos */
    .section-title-container {
        text-align: center;
        margin: 40px auto 35px;
        max-width: 600px;
    }
    .section-title {
        font-size: 28px;
        font-weight: 900;
        color: var(--text, #1f2430);
        margin-bottom: 4px;
    }
    .section-subtitle {
        font-size: 16px;
        color: var(--muted, #5b6372);
        line-height: 1.5;
    }
    
    /* Responsivo do hero */
    @media (max-width: 992px) {
        .home-hero {
            grid-template-columns: 1fr;
            text-align: center;
        }

        .home-hero__subtitle {
            max-width: unset;
        }

        .home-hero__media {
            margin-top: 20px;
        }
        
        /* Ajuste para centralizar a caixa de info e alinhar o texto */
        .hero-info-box {
           text-align: left;
        }
    }
</style>

<style>
    /* Estilos dos Cards (sem alterações) */
    .ss-grid--pill {
        --gap: 18px;
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(340px, 1fr));
        gap: var(--gap);
        margin-top: 18px;
    }
    .ss-card.ss-pill {
        position: relative;
        display: grid;
        grid-template-columns: 150px 1fr;
        align-items: center;
        min-height: 150px;
        border-radius: 28px;
        overflow: hidden;
        text-decoration: none;
        border: 1px solid rgba(255, 255, 255, .10);
        box-shadow: 0 10px 22px rgba(0, 0, 0, .12);
        transition: transform .18s, box-shadow .18s, border-color .18s;
        padding: 10px 16px 10px 10px;
    }
    .ss-card.ss-pill.is-open:hover {
        transform: translateY(-3px);
        border-color: rgba(255, 255, 255, .18);
        box-shadow: 0 16px 30px rgba(0, 0, 0, .18);
    }
    .ss-tint {
        position: absolute;
        inset: 0;
        background: linear-gradient(180deg, rgba(0, 0, 0, .08), rgba(0, 0, 0, .22));
        pointer-events: none;
    }
    .ss-card-media {
        display: grid;
        place-items: center;
        aspect-ratio: 1 / 1;
        border-radius: 20px;
    }
    .ss-card-media img {
        max-width: 78%;
        height: auto;
        display: block;
        filter: drop-shadow(0 4px 10px rgba(0, 0, 0, .25));
    }
    .ss-card-body {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
        padding-left: 10px;
    }
    .ss-card-title {
        color: #fff;
        font-size: 18px;
        font-weight: 800;
        margin: 0;
        line-height: 1.25;
        text-shadow: 0 1px 0 rgba(0, 0, 0, .18);
    }
    .ss-card-cta {
        font-size: 12px;
        padding: 8px 12px;
        border-radius: 999px;
        background: #ffd25e;
        color: #0b2230;
        font-weight: 900;
        letter-spacing: .4px;
        text-transform: uppercase;
        white-space: nowrap;
        box-shadow: 0 2px 0 rgba(0, 0, 0, .12);
    }
    .ss-card.is-locked {
        cursor: default;
    }
    .ss-card.is-locked .ss-card-media img {
        filter: grayscale(100%) saturate(85%) brightness(92%) drop-shadow(0 4px 10px rgba(0, 0, 0, .25));
        opacity: .95;
    }
    .ss-lock-overlay {
        position: absolute;
        inset: 0;
        border-radius: 28px;
        background: linear-gradient(180deg, rgba(20, 20, 20, .20), rgba(20, 20, 20, .42));
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .ss-lock-content {
        text-align: center;
        color: #fff;
        font-weight: 800;
    }
    .ss-lock-icon {
        font-size: 34px;
        display: block;
        margin-bottom: 6px;
    }
    .ss-lock-text {
        font-size: 12px;
        line-height: 1.2;
    }
    @media (max-width: 640px) {
        .ss-card.ss-pill {
            grid-template-columns: 120px 1fr;
            min-height: 140px;
        }
        .ss-card-media img {
            max-width: 72%;
        }
        .ss-card-title {
            font-size: 17px;
        }
    }
</style>
@endsection