<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- TÍTULO DINÂMICO --}}
    <title>@yield('title')</title>

    {{-- FAVICON --}}
    <link rel="icon" href="{{ asset('img/favicon.png') }}" type="image/x-icon">

    {{-- CSS BOOTSTRAP 5 --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

    {{-- FONTES --}}
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    {{-- CSS DO SISTEMA --}}
    <link rel="stylesheet" href="{{ mix('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">

    {{-- JS DO SISTEMA --}}
    <script src="{{ asset('js/scripts.js') }}" defer></script>

    {{-- ÍCONES --}}
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.1.0/css/all.css" integrity="sha384-lKuwvrZot6UHsBSfcMvOkWwlCMgc0TaWr+30HWe3a4ltaBwTZhyTEggF5tJv8tbt" crossorigin="anonymous">
    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

    {{-- BOOTSTRAP BUNDLE COM POPPER (JS) --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    {{-- LIVEWIRE --}}
    @livewire('check-session')
    @livewireStyles
</head>

<body class="font-sans">
    <header>
        <nav class="navbar navbar-expand-lg navbar-light bodyModulo3" id="topbar">
            <div class="flex justify-start wrap" style="width: 300px;">
                <div id="menuToggle" class="d-sm-block d-md-none">
                    {{-- BOTÃO MENU (MOSTRAR SIDEBAR) --}}
                    <ion-icon id="showSidebarBtn" name="menu-outline" size="large" style="display: inline-block;"></ion-icon>
                </div>
                <div class="block">
                    <img src="{{ asset('img/logos.png') }}" id="logoHeader" alt="Logo">
                </div>
            </div>
            <div id="topbar-logo">
                <img src="{{ asset('img/safetystart_logo.png') }}" id="logostart" alt="SW">
            </div>
        </nav>
    </header>

    <main id="main">
        @auth
        {{-- SIDEBAR --}}
        <div id="sidebar" class="bodyModulo3">
            <div style="text-align: right;" class="d-sm-block d-md-none">
                {{-- BOTÃO FECHAR (ESCONDER SIDEBAR) --}}
                <ion-icon id="hideSidebarBtn" name="close-outline" size="large" style="cursor: pointer;" class="text-white"></ion-icon>
            </div>

            <div class="sidebar-content">
                <h3 class="text-center text-white" style="font-size: 26px;margin-bottom: 0;">
                    {{ substr(Auth::user()->name, 0, 15) }}
                </h3>

                <div class="row"><a href="/usuario" class="text-center text-white" style="text-decoration: none;font-weight: 700;">Ver Perfil</a></div>

                <div class="flex text-white rounded-lg ml-2 mr-2 px-3 py-2 my-4" style="background-color: #243782; justify-content: space-around;">
                    @php
                    $u = Auth::user();

                    // Quantos módulos concluídos (usu_resp_mod1..5 === 1)
                    $modsDone = 0;
                    for ($i = 1; $i <= 5; $i++) {
                        if ((int) data_get($u, "usu_resp_mod{$i}" )===1) {
                        $modsDone++;
                        }
                        }

                        // Pontos
                        $score=0;

                        // +10 por módulo concluído
                        $score +=$modsDone * 10;

                        // +5 por diária correta (usu_resp_dia1..5===1)
                        for ($i=1; $i <=5; $i++) {
                        if ((int) data_get($u, "usu_resp_dia{$i}" )===1) {
                        $score +=5;
                        }
                        }

                        // +5 por minuto concluído (usu_min1..5===1)
                        for ($i=1; $i <=5; $i++) {
                        if ((int) data_get($u, "usu_min{$i}" )!=0) {
                        $score +=5;
                        }
                        }

                        // Exibir com 2 dígitos (tipo "00" , "05" , "12" …)
                        $scoreStr=str_pad((string) $score, 2, '0' , STR_PAD_LEFT);
                        @endphp

                        <div class="flex flex-wrap justify-center">
                        <span class="text-center w-full text-l" style="font-weight: bold">Pontuação</span>
                        <span class="text-center w-full text-xl" style="font-weight: bold">{{ $scoreStr }}</span>
                </div>

                <div class="flex flex-wrap justify-center border border-white">
                    <span></span>
                </div>

                <div class="flex flex-wrap justify-center ml-2">
                    <span class="text-center w-full text-l" style="font-weight: bold">Módulos</span>
                    <span class="text-center w-full text-xl" style="font-weight: bold">{{ $modsDone }}/5</span>
                </div>
            </div>

            <ul class="navbar-nav ml-2">
                <li class="nav-item">
                    <a href="/dashboard" class="nav-link">
                        <img src="{{ asset('img/icons/icon_home.png') }}" style="float: left;height: 35px;" alt="">
                        <span>Início</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/modulos" class="nav-link">
                        <img src="{{ asset('img/icons/icon_jornada.png') }}" style="float: left;height: 35px;" alt="">
                        <span>Trilha do Conhecimento</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/conquistas" class="nav-link">
                        <img src="{{ asset('img/icons/icon_conquista.png') }}" style="float: left;height: 35px;" alt="">
                        <span>Conquistas</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/diarias" class="nav-link">
                        <img src="{{ asset('img/icons/icon_desafio.png') }}" style="float: left;height: 35px;" alt="">
                        <span>Desafio Diário</span>
                    </a>
                </li>
                <li class="nav-item">
                    {{-- Minuto da Percepção -> /minutos --}}
                    <a href="/minutos" class="nav-link">
                        <img src="{{ asset('img/icons/icon_registro.png') }}" style="float: left;height: 35px;" alt="">
                        <span>Minuto da Percepção</span>
                    </a>
                </li>
            </ul>

            <div class="flex justify-center" id="imgMenuAssinatura">
                <img src="{{ asset('img/frase.png') }}" style="width: 180px;" alt="Frase">
            </div>

            <div class="blocoFooterMenu ml-2">
                <ul>
                    <li class="nav-item">
                        <a href="/comojogar" class="nav-link">
                            <i class="fa fa-question" style="font-size: 15px;margin-right: 7px;margin-left: 5px;"></i>
                            <span>Como jogar?</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#" class="nav-link" data-bs-toggle="modal" data-bs-target="#modalSuporte">
                            <i class="fa fa-headset" style="font-size: 15px;margin-right: 7px;margin-left: 5px;"></i>
                            <span>Suporte</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="/entenda" class="nav-link">
                            <i class="fa fa-info" style="font-size: 15px;margin-right: 10px;margin-left: 6px;"></i>
                            <span>Regulamento</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <form action="/logout" method="POST">
                            @csrf
                            <a href="/logout" class="nav-link" onclick="event.preventDefault(); this.closest('form').submit();">
                                <i class="fa fa-power-off" style="font-size: 15px;margin-right: 6px;"></i>
                                <span>Sair</span>
                            </a>
                        </form>
                    </li>
                </ul>
            </div>
        </div>
        </div>
        @endauth

        <div id="content">
            @yield('content')
        </div>

        <footer id="footer">
            <p>AB MKT & TECH &copy; 2025</p>
        </footer>
    </main>
    <!-- Modal: Suporte -->
    <div class="modal fade"
        id="modalSuporte"
        tabindex="-1"
        aria-labelledby="modalSuporteLabel"
        aria-hidden="true"
        wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content rounded-4" wire:ignore>
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="modalSuporteLabel">
                        <i class="fa fa-question-circle me-2"></i> Precisa de ajuda?
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                </div>

                <div class="modal-body text-center">
                    <div class="container">
                        <p>Se você está enfrentando problemas ou tem alguma dúvida sobre o sistema, nossa equipe está pronta para ajudar!</p>
                        <p>A forma mais rápida de obter suporte é através do nosso WhatsApp.<br> Clique no botão para iniciar uma conversa.</p>
                    </div>
                    <div class="container mt-2 mb-2">
                        <a href="https://api.whatsapp.com/send?phone=5531975890011" target="_blank" class="btn btn-success btn-lg">
                            <i class="fab fa-whatsapp me-2"></i> Chamar no WhatsApp
                        </a>
                    </div>
                </div>

                <div class="text-muted small text-center">
                    <p class="mb-1">
                        <strong>Horário de atendimento:</strong><br>
                        Segunda a Sexta, das 09h às 18h.<br>
                        <strong>Prazo de até 4 horas úteis</strong>
                    </p>
                </div><br>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    @livewireScripts
</body>

</html>