@extends('layouts.main')

@section('title', 'SafetyStart - Diárias')

@section('content')

@php
use Carbon\Carbon;

// ==============================
// REGRAS DE LIBERAÇÃO (BRASIL)
// ==============================
$tz = 'America/Sao_Paulo';

// INÍCIO DA CAMPANHA (ajustado para ser consistente com as outras páginas)
$campaignStart = Carbon::create(2025, 8, 18, 8, 0, 0, $tz);

$now = Carbon::now($tz);

// Janela aberta do dia i (1..5)
$win = function (int $i) use ($campaignStart) {
    $start = $campaignStart->copy()->addDays($i - 1); // 08:00 do dia i
    $end = $start->copy()->addDay()->subSecond(); // 07:59:59 do dia seguinte
    return [$start, $end];
};

// Verifica se o desafio do dia está aberto
$isOpen = function (int $i) use ($win, $now) {
    [$s, $e] = $win($i);
    return $now->between($s, $e);
};

// Status do usuário (0=pendente, 1=correto, 2=errado)
$st1 = Auth::user()->usu_resp_dia1 ?? 0;
$st2 = Auth::user()->usu_resp_dia2 ?? 0;
$st3 = Auth::user()->usu_resp_dia3 ?? 0;
$st4 = Auth::user()->usu_resp_dia4 ?? 0;
$st5 = Auth::user()->usu_resp_dia5 ?? 0;

$cards = [
    1 => ['bg' => 'bodyModulo1', 'titulo' => 'Desafio 1', 'href' => url('/pergunta1'), 'status' => $st1],
    2 => ['bg' => 'bodyModulo2', 'titulo' => 'Desafio 2', 'href' => url('/pergunta2'), 'status' => $st2],
    3 => ['bg' => 'bodyModulo3', 'titulo' => 'Desafio 3', 'href' => url('/pergunta3'), 'status' => $st3],
    4 => ['bg' => 'bodyModulo4', 'titulo' => 'Desafio 4', 'href' => url('/pergunta4'), 'status' => $st4],
    5 => ['bg' => 'bodyModulo5', 'titulo' => 'Desafio 5', 'href' => url('/pergunta5'), 'status' => $st5],
];
@endphp

<div class="m-b-40">

    <section class="home-hero home-hero--light">
        <div class="home-hero__content">
            <h2 class="home-hero__title">
                Desafio Diário
            </h2>
            
            {{-- MELHORIA: O novo texto foi inserido e reestruturado --}}
            <p class="home-hero__subtitle">
                Mostre o que você aprendeu! Todo dia, às 08:00, uma nova pergunta será liberada, e você terá 24 horas para testar seus conhecimentos.
            </p>

            <div class="hero-info-box">
                <h3 class="hero-info-title">Como Funciona:</h3>
                <ul class="hero-info-list">
                    <li><i class="fas fa-question-circle"></i> <strong>Liberação:</strong> Uma nova pergunta às 08:00, junto com o vídeo do Minuto da Percepção.</li>
                    <li><i class="fas fa-clock"></i> <strong>Tempo de Resposta:</strong> Você tem 24 horas para responder e garantir a absorção do conteúdo.</li>
                    <li><i class="fas fa-check-circle"></i> <strong>Pontuação:</strong> Respostas corretas acumulam pontos para seu desempenho na jornada.</li>
                </ul>
            </div>

            <p class="home-hero__closing-text">
                Este é o momento de colocar em prática o que você aprendeu. Não perca a chance de se desafiar e avançar!
            </p>

        </div>

        <div class="home-hero__media">
            <img src="{{ asset('img/12.png') }}" alt="Ilustração de segurança no trabalho">
        </div>
    </section>

    {{-- MELHORIA: Título de transição adicionado --}}
    <div class="section-title-container">
        <h3 class="section-title">Responda ao Desafio do Dia</h3>
        <p class="section-subtitle">Apenas o desafio do dia atual fica disponível para resposta.</p>
    </div>


    @if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @elseif (session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="dd-grid">
        @foreach ($cards as $i => $c)
        @php
        $openNow  = $isOpen($i);
        $answered = (int)$c['status'] !== 0;
        $locked   = !$openNow;
        
        // Define o texto e o ícone do status
        if ($locked) {
            $statusText = 'Bloqueado';
            $statusIcon = 'fa-lock';
        } elseif ($answered) {
            $statusText = $c['status'] == 1 ? 'Correto' : 'Errado';
            $statusIcon = $c['status'] == 1 ? 'fa-check-circle' : 'fa-times-circle';
        } else {
            $statusText = 'Pendente';
            $statusIcon = 'fa-hourglass-half';
        }
        
        $linkAttrs = $openNow && !$answered ? 'href="'.$c['href'].'"' : 'role="button"';
        [$wStart, $wEnd] = $win($i);
        @endphp

        <a {!! $linkAttrs !!}
           class="dd-card dd-pill {{ $c['bg'] }} {{ $locked ? 'is-locked' : 'is-open' }} {{ $answered ? 'is-answered' : '' }}"
           aria-disabled="{{ $locked || $answered ? 'true' : 'false' }}"
           @if($locked || $answered) tabindex="-1" @endif>

            <span class="dd-tint" aria-hidden="true"></span>

            <div class="dd-media">
                <img class="dd-day-icon" src="{{ asset(sprintf('img/dia%02d.png', $i)) }}" alt="Dia {{ $i }}"
                     onerror="this.src='{{ asset('img/SAFETYSTART.png') }}'">
            </div>

            <div class="dd-body">
                <div class="dd-top">
                    <span class="dd-badge dd-badge--dark">Dia {{ $i }}</span>
                    {{-- MELHORIA: Badges de status foram ativados e aprimorados --}}
                    <span class="dd-badge dd-badge--status {{ $locked ? 'dd-status-locked' : ($answered ? ($c['status']==1 ? 'dd-status-correct' : 'dd-status-wrong') : 'dd-status-pending') }}">
                        <i class="fa {{ $statusIcon }} me-1"></i>
                        {{ $statusText }}
                    </span>
                </div>

                <h3 class="dd-title">{{ $c['titulo'] }}</h3>

                @if($locked)
                <p class="dd-desc">Desafio encerrado ou ainda não disponível.</p>
                @elseif($answered)
                <p class="dd-desc">Você já respondeu a este desafio.</p>
                @else
                <p class="dd-desc">Clique para responder a pergunta do dia.</p>
                @endif

                <div class="dd-bottom">
                    @if(!$locked && !$answered)
                    <span class="dd-cta">Responder <i class="fa fa-arrow-right ms-2"></i></span>
                    @endif
                </div>
            </div>
            
            @if($locked)
            <div class="dd-overlay" aria-hidden="true">
                <i class="fa fa-lock dd-ov-icon"></i>
            </div>
            @endif
        </a>
        @endforeach
    </div>
</div>

{{-- ==================== ESTILOS ==================== --}}
<style>
    /* Estilos Gerais (sem alterações) */
    #home {
        --text: #1f2430;
        --muted: #5b6372;
        --accent: #1691ff;
        --brand: #07509D;
    }

    /* HERO base */
    .home-hero {
        position: relative;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        align-items: center;
        padding: 20px;
        border-radius: 24px;
        overflow: hidden;
        margin-bottom: 26px;
    }

    .home-hero__content {
        position: relative;
        z-index: 1;
        padding: 8px;
    }

    .home-hero__media {
        position: relative;
        z-index: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: -20px;
        overflow: hidden;
    }

    .home-hero__media img {
        max-width: 100%;
        height: auto;
        object-fit: contain;
    }

    .home-hero--light {
        background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
        border: 1px solid #e9edf6;
        box-shadow: 0 10px 26px rgba(0, 0, 0, .06);
        color: var(--text);
    }

    .home-hero__title {
        margin: 2px 0 10px;
        font-size: 36px;
        font-weight: 900;
        line-height: 1.15;
    }

    .home-hero__subtitle {
        margin: 0 0 18px;
        color: var(--muted);
        max-width: 55ch;
        font-size: 16px;
        line-height: 1.6;
    }

    /* Box de Informações */
    .hero-info-box {
        background-color: #f0f4fa;
        border-left: 4px solid var(--brand, #07509D);
        padding: 16px 20px;
        border-radius: 8px;
        margin: 20px 0;
    }

    .hero-info-title {
        font-size: 16px;
        font-weight: 900;
        color: var(--text);
        margin-top: 0;
        margin-bottom: 12px;
    }

    .hero-info-list {
        list-style: none;
        padding: 0;
        margin: 0;
        font-size: 14px;
        color: var(--muted, #5b6372);
    }

    .hero-info-list li {
        display: flex;
        align-items: flex-start;
        gap: 12px;
    }

    .hero-info-list li:not(:last-child) {
        margin-bottom: 10px;
    }

    .hero-info-list i {
        color: var(--brand, #07509D);
        font-size: 16px;
        margin-top: 2px;
    }

    .home-hero__closing-text {
        font-size: 15px;
        color: var(--muted);
        margin-top: 18px;
        margin-bottom: 0;
        line-height: 1.6;
    }

    /* Título da Seção */
    .section-title-container {
        text-align: center;
        margin: 40px auto 35px;
        max-width: 600px;
    }

    .section-title {
        font-size: 28px;
        font-weight: 900;
        color: var(--text, #1f2430);
        margin-bottom: 4px;
    }

    .section-subtitle {
        font-size: 16px;
        color: var(--muted, #5b6372);
        line-height: 1.5;
    }

    /* Responsivo do Hero */
    @media (max-width: 992px) {
        .home-hero {
            grid-template-columns: 1fr;
            text-align: center;
        }
        .home-hero__subtitle {
            max-width: unset;
        }
        .home-hero__media {
            margin-top: 20px;
        }
        .hero-info-box {
            text-align: left;
        }
    }
</style>

<style>
    /* Estilos dos Cards (prefixo dd-) */
    .dd-grid {
        --gap: 22px;
        display: grid;
        gap: var(--gap);
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        margin-top: 18px;
    }

    .dd-card.dd-pill {
        position: relative;
        display: grid;
        grid-template-columns: 150px 1fr;
        align-items: center;
        min-height: 150px;
        border-radius: 28px;
        overflow: hidden;
        text-decoration: none;
        color: #fff;
        border: 1px solid rgba(255, 255, 255, 0.10);
        box-shadow: 0 12px 26px rgba(0, 0, 0, .14), 0 6px 16px rgba(0, 0, 0, .10);
        transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
        padding: 10px 16px 10px 10px;
    }
    .dd-card.is-answered, .dd-card.is-locked {
        cursor: not-allowed;
    }
    .dd-card.is-open:not(.is-answered):hover {
        transform: translateY(-3px);
        box-shadow: 0 18px 34px rgba(0, 0, 0, .18), 0 10px 24px rgba(0, 0, 0, .12);
        border-color: rgba(255, 255, 255, 0.18);
    }
    
    .dd-tint {
        position: absolute; inset: 0;
        background: linear-gradient(180deg, rgba(0, 0, 0, .06), rgba(0, 0, 0, .22));
        pointer-events: none;
    }

    .dd-media {
        display: grid;
        place-items: center;
        aspect-ratio: 1/1;
        border-radius: 20px;
    }

    .dd-day-icon {
        width: 100px; height: 100px;
        object-fit: contain;
        display: block;
        max-width: none;
        filter: drop-shadow(0 4px 10px rgba(0, 0, 0, .28));
    }

    .dd-body {
        display: flex; flex-direction: column;
        gap: 6px; padding-left: 12px;
    }

    .dd-top {
        display: flex; justify-content: space-between;
        align-items: center;
    }

    .dd-badge {
        display: inline-flex; align-items: center;
        gap: 6px; padding: 6px 12px;
        border-radius: 999px; font-weight: 800; font-size: 12px;
        box-shadow: inset 0 0 0 1px rgba(255, 255, 255, .08);
        backdrop-filter: blur(2px);
    }
    .dd-badge--dark { background: rgba(0, 0, 0, .32); }
    .dd-status-pending { background: rgba(0, 80, 180, .35); }
    .dd-status-locked { background: rgba(0, 0, 0, .46); }
    .dd-status-correct { background: rgba(0, 128, 0, .45); }
    .dd-status-wrong { background: rgba(220, 20, 20, .45); }

    .dd-title {
        margin: 0; font-weight: 900;
        font-size: 18px;
        text-shadow: 0 1px 0 rgba(0, 0, 0, .18);
    }

    .dd-desc { margin: 0; opacity: .95; font-size: 14px; }
    .dd-bottom { margin-top: 6px; }

    .dd-cta {
        display: inline-flex; align-items: center; justify-content: center;
        padding: 10px 18px; border-radius: 999px;
        background: #ffd25e; color: #0b2230;
        font-weight: 900; letter-spacing: .2px;
        box-shadow: 0 6px 18px rgba(255, 210, 94, 0.3);
        transition: transform .15s ease, box-shadow .15s ease;
    }
    .dd-card.is-open:not(.is-answered) .dd-cta:hover {
        transform: translateY(-1px);
        box-shadow: 0 10px 22px rgba(255, 210, 94, .4);
    }

    .dd-overlay {
        position: absolute; inset: 0; border-radius: 28px;
        background: linear-gradient(180deg, rgba(20, 20, 20, .22), rgba(20, 20, 20, .38));
        display: flex; align-items: center; justify-content: center;
        pointer-events: none;
    }

    .dd-ov-icon { font-size: 38px; opacity: .35; }
    
    @media (max-width: 640px) {
        .dd-card.dd-pill {
            grid-template-columns: 120px 1fr;
            min-height: 140px;
        }
        .dd-media img { max-width: 72%; }
        .dd-title { font-size: 17px; }
    }
</style>
@endsection