@extends('layouts.main')

@section('title', 'SafetyStart - Conquistas')

@push('styles')
<style>
  /* Estética geral (sem alterações) */
  .page-hero {
    background: radial-gradient(1200px 600px at 0% 0%, #eef6ff 0%, #ffffff 60%);
    border-radius: 1.25rem;
  }

  @media (prefers-color-scheme: dark) {
    .page-hero {
      background: radial-gradient(1200px 600px at 0% 0%, #0b1220 0%, #0e1525 60%);
    }

    .text-body-secondary {
      color: #9fb0c2 !important;
    }

    .badge-card {
      background: rgba(255, 255, 255, 0.03) !important;
      border-color: rgba(255, 255, 255, 0.08) !important;
    }
  }

  /* Cards de emblema */
  .badge-card {
    transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
  }

  .badge-card:hover,
  .badge-card:focus-within {
    transform: translateY(-2px);
    box-shadow: 0 12px 24px rgba(2, 12, 27, 0.08);
    border-color: rgba(2, 12, 27, 0.1);
  }

  .badge-chip {
    white-space: nowrap;
  }

  /* ============================================== */
  /* NOVAS ANIMAÇÕES PARA OS EMBLEMAS DESBLOQUEADOS */
  /* ============================================== */

  /* Container para o ícone, necessário para o efeito de brilho */
  .badge-icon-wrapper {
    position: relative;
    overflow: hidden;
    /* Garante que o brilho não saia do ícone */
    border-radius: 50%;
    /* Ajuda a conter o brilho em ícones redondos */
  }

  /* Estado inicial do ícone bloqueado */
  .badge-icon.locked {
    filter: grayscale(1) contrast(.9) opacity(.65);
  }

  /* Animação de desbloqueio: "pula" na tela e ganha cor */
  @keyframes badge-unlock {
    0% {
      transform: scale(0.8);
      filter: grayscale(1) opacity(0);
    }

    60% {
      transform: scale(1.1);
      filter: grayscale(0) opacity(1);
    }

    100% {
      transform: scale(1);
      filter: grayscale(0) opacity(1);
    }
  }

  /* Animação do brilho que passa sobre o ícone */
  @keyframes badge-shine {
    0% {
      transform: translateX(-150%) skewX(-25deg);
    }

    100% {
      transform: translateX(150%) skewX(-25deg);
    }
  }

  /* Aplica a animação de desbloqueio */
  .badge-icon.unlocked-animated {
    animation: badge-unlock 0.7s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
  }

  /* Cria o elemento de brilho e aplica sua animação */
  .badge-icon.unlocked-animated::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 50%;
    height: 100%;
    background: linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, .3) 50%, rgba(255, 255, 255, 0) 100%);
    animation: badge-shine 1s ease-in-out forwards;
    animation-delay: 0.5s;
    /* O brilho acontece após o "pulo" */
  }
</style>

@endpush

@section('content')
<div class="container py-3 py-md-4">

  {{-- HERO --}}
  <section class="home-hero home-hero--light">
    <div class="home-hero__content">
      <h2 class="home-hero__title">
        Galeria de Conquistas
      </h2>
      {{-- MELHORIA: Texto da introdução reestruturado --}}
      <p class="home-hero__subtitle">
        Galeria de Conquistas: Celebre Suas Vitórias!<br>
        Aqui, todas as suas conquistas ganham destaque! A Galeria de Conquistas é o espaço onde você pode ver todos os badges que conquistou ao longo da sua jornada.
      </p>
      <p class="home-hero__closing-text">
        Cada badge representa um marco importante no seu aprendizado e desenvolvimento em percepção de risco. A cada conquista, você demonstra seu compromisso com a segurança e o aprimoramento contínuo.<br>
      </p>
    </div>

    <div class="home-hero__media">
      <img src="{{ asset('img/12.png') }}" alt="Ilustração de segurança no trabalho">
    </div>
  </section>

  {{-- MELHORIA: Título de transição adicionado --}}
  <div class="section-title-container">
    <h3 class="section-title">Seu Progresso</h3>
  </div>

  @php
  // Lógica PHP permanece a mesma
  $modules = [
  ['field' => 'usu_resp_mod1', 'title' => 'Mestre da Percepção', 'unlocked' => ['img' => 'emblema_01.png', 'text' => 'Você sabe a diferença fundamental entre Perigo e Risco.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete o módulo 1 para desbloquear.']],
  ['field' => 'usu_resp_mod2', 'title' => 'Vigilante de Elite', 'unlocked' => ['img' => 'emblema_02.png', 'text' => 'Você reconhece as atividades de risco crítico e age com Tolerância Zero.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete o módulo 2 para desbloquear.']],
  ['field' => 'usu_resp_mod3', 'title' => 'Aliado(a) das Máquinas', 'unlocked' => ['img' => 'emblema_03.png', 'text' => 'Você respeita as proteções das máquinas como aliadas e opera com consciência.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete o módulo 3 para desbloquear.']],
  ['field' => 'usu_resp_mod4', 'title' => 'Defesa Inteligente', 'unlocked' => ['img' => 'emblema_04.png', 'text' => 'Você domina a arte de planejar a segurança com a ARPT antes de agir.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete o módulo 4 para desbloquear.']],
  ['field' => 'usu_resp_mod5', 'title' => 'Estrategista da Segurança', 'unlocked' => ['img' => 'emblema_05.png', 'text' => 'Você domina a Hierarquia de Controles para encontrar a solução mais forte.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete o módulo 5 para desbloquear.']],
  ['field' => 'usu_min5', 'title' => 'No tempo certo', 'unlocked' => ['img' => 'emblema_06.png', 'text' => 'Você viu todos os minutos da segurança.'], 'locked' => ['img' => 'emblema_bloqueado.png', 'text' => 'Complete todos minutos da segurança para desbloquear.']],
  ];

  $earned = collect($modules)->filter(fn($m) => data_get($usuario, $m['field']) != 0)->count();
  $total = count($modules);
  $percent = intval(($earned / max($total,1)) * 100);
  @endphp

  {{-- PROGRESSO --}}
  <div class="mb-4">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <span class="small text-body-secondary">Conquistas</span>
      <span class="small fw-semibold">{{ $earned }} / {{ $total }} emblemas</span>
    </div>
    <div class="progress" style="height:.75rem;">
      <div class="progress-bar bg-success" role="progressbar"
        style="width: {{ $percent }}%;"
        aria-valuenow="{{ $percent }}" aria-valuemin="0" aria-valuemax="100">
        <span class="visually-hidden">{{ $percent }}%</span>
      </div>
    </div>
  </div>

  {{-- LISTA DE EMBLEMAS --}}
  <section aria-label="Lista de emblemas">
    <div class="row row-cols-1 row-cols-lg-2 g-3">
      @foreach($modules as $m)
      @php $unlocked = data_get($usuario, $m['field']) != 0; @endphp
      <div class="col">
        <div class="badge-card d-flex align-items-center gap-3 p-3 rounded-4 h-100 border bg-white">
          {{-- MELHORIA: Wrapper adicionado para conter a animação de brilho --}}
          <div class="badge-icon-wrapper flex-shrink-0">
            <img
              src="{{ asset('img/' . ($unlocked ? $m['unlocked']['img'] : $m['locked']['img'])) }}"
              width="88" height="88"
              {{-- MELHORIA: Classe 'unlocked-animated' adicionada para ativar a animação --}}
              class="img-fluid badge-icon {{ $unlocked ? 'unlocked-animated' : 'locked' }}"
              alt="{{ $m['title'] }} - {{ $unlocked ? 'conquistado' : 'bloqueado' }}">
          </div>
          <div class="flex-grow-1">
            <h3 class="h6 mb-1 fw-bold">{{ $m['title'] }}</h3>
            <p class="mb-0 small text-body-secondary">
              {{ $unlocked ? $m['unlocked']['text'] : $m['locked']['text'] }}
            </p>
          </div>
          <span class="ms-auto badge rounded-pill badge-chip {{ $unlocked ? 'text-bg-success' : 'text-bg-secondary' }}">
            {{ $unlocked ? 'Conquistado' : 'Bloqueado' }}
          </span>
        </div>
      </div>
      @endforeach
    </div>
  </section>

  {{-- CSS do Hero e Seções (para manter consistência com outras páginas) --}}
  <style>
    #home {
      --brand: #07509D;
    }

    .home-hero {
      position: relative;
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 30px;
      align-items: center;
      padding: 20px;
      border-radius: 24px;
      overflow: hidden;
      margin-bottom: 26px;
    }

    .home-hero__content {
      position: relative;
      z-index: 1;
      padding: 8px;
    }

    .home-hero__media {
      position: relative;
      z-index: 1;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: -20px;
      overflow: hidden;
    }

    .home-hero__media img {
      max-width: 100%;
      height: auto;
      object-fit: contain;
    }

    .home-hero--light {
      background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
      border: 1px solid #e9edf6;
      box-shadow: 0 10px 26px rgba(0, 0, 0, .06);
      color: var(--text);
    }

    .home-hero__title {
      margin: 2px 0 10px;
      font-size: 36px;
      font-weight: 900;
      line-height: 1.15;
    }

    .home-hero__subtitle {
      margin: 0 0 18px;
      color: var(--muted);
      max-width: 55ch;
      font-size: 16px;
      line-height: 1.6;
    }

    .home-hero__closing-text {
      font-size: 15px;
      color: var(--muted);
      margin-top: 18px;
      margin-bottom: 0;
      line-height: 1.6;
    }

    .section-title-container {
      text-align: center;
      margin: 40px auto 25px;
      max-width: 600px;
    }

    .section-title {
      font-size: 28px;
      font-weight: 900;
      color: var(--text, #1f2430);
      margin-bottom: 4px;
    }

    @media (max-width: 992px) {
      .home-hero {
        grid-template-columns: 1fr;
        text-align: center;
      }

      .home-hero__subtitle {
        max-width: unset;
      }

      .home-hero__media {
        margin-top: 20px;
      }
    }
  </style>
</div>
@endsection

@push('scripts')
{{-- Não são necessários scripts para esta animação em CSS --}}
@endpush