@extends('layouts.main')

@section('title', 'SafetyStart - Como Jogar')

@section('content')
<div class="container mx-auto px-4 py-8">
    
    <div class="bg-white rounded-lg shadow-lg p-6 md:p-8">

        <div class="border-b border-gray-200 mb-6">
            <nav class="-mb-px flex space-x-4 overflow-x-auto" aria-label="Tabs">
                <button class="tab-button active" data-target="como-jogar">
                    Como Jogar
                </button>
            </nav>
        </div>

        <div>
            <section id="como-jogar" class="tab-content active">
                <h2 class="text-xl font-semibold text-gray-800 mb-6 titleItems">SafetyStart - Como Jogar</h2>
                
                <div class="space-y-6 text-gray-700">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">1. Objetivo</h3>
                        <p class="mt-2">Aprenda e Aplique</p>
                        <p class="mt-2">O objetivo do SafetyStart é educar sobre segurança no trabalho, saúde e ergonomia durante a SIPAT 2025. Você poderá aprender com a Trilha do Conhecimento para responder perguntas diárias e assistir o minuto da percepção.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">2. Inscrição e Acesso</h3>
                        <p class="mt-2">Inscreva-se Gratuitamente</p>
                        <p class="mt-2">As inscrições são de 18 a 22 de agosto.</p>
                        <p class="mt-2">Acesse e ative seu usuário.</p>
                        <p class="mt-2">Para acesso utilize seu SAP ID e a Matricula.</p>
                        <p class="mt-2">Mantenha suas credenciais seguras, e não compartilhe com ninguém.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">3. Como Usar a Trilha do Conhecimento</h3>
                        <p class="mt-2">Siga os Módulos</p>
                        <p class="mt-2">Cada módulo refere-se a um tema específico da Percepção de Risco.</p>
                        <p class="mt-2">Assista aos vídeos, leia os textos e faça o game para ganhar pontos.</p>
                        <p class="mt-2">Complete todos os módulos para receber as insígnias.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">4. Perguntas Diárias</h3>
                        <p class="mt-2">Ganhe Pontos Diários</p>
                        <p class="mt-2">Responda ao Desafio Diário entre 18 e 22 de agosto.</p>
                        <p class="mt-2">Cada resposta correta vale 05 pontos.</p>
                        <p class="mt-2">As perguntas ficam disponíveis por 24 horas.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">5. Minuto da Percepção</h3>
                        <p class="mt-2">Aprenda com dicas para a Percepção de Risco</p>
                        <p class="mt-2">Assista a vídeos entre 18 e 22 de agosto.</p>
                        <p class="mt-2">Avalie o conteúdo, e receba 05 pontos.</p>
                        <p class="mt-2">Os minutos ficam disponíveis por 24 horas.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">6.  Uso Seguro</h3>
                        <p class="mt-2">Priorize a Segurança</p>
                        <p class="mt-2">Importante: Se estiver utilizando o aplicativo no celular, certifique-se de estar em um local seguro e sempre parado. Não utilize o celular em movimento.</p>
                        <p class="mt-2">Use o SafetyStart em um ambiente seguro.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">7. Pontuação e Premiação</h3>
                        <p class="mt-2">Acumule Pontos e Ganhe Prêmios</p>
                        <p class="mt-2">Complete módulos, responda perguntas diárias e registre riscos para acumular pontos.</p>
                        <p class="mt-2">Participe do sorteio de prêmios se alcançar 50 pontos e completar todos os módulos da Trilha do Conhecimento.</p>
                        <p class="mt-2">Sorteio em 02/09/2025.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">8. Prêmios e Regras para Participação</h3>
                        <p class="mt-2">Ganhe Prêmios Incríveis</p>
                        <p class="mt-2">Ao participar do SafetyStart, você concorre a prêmios como:</p>
                        <ul class="list-disc ml-6">
                            <li>100 GiftCard de R$ 100,00</li>
                        </ul>
                        <p class="mt-2">Para Participar:</p>
                        <ul class="list-disc ml-6">
                            <li>Complete todos os módulos das Trilha do Conhecimento.</li>
                            <li>Alcance no mínimo 50 pontos.</li>
                        </ul>
                        <p class="mt-2">Somente os empregados Stellantis das unidades Betim Veículos, PWT e Mopar, que cumprirem essas regras estarão elegíveis para o sorteio.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">Pronto para Começar?</h3>
                    </div>
                </div>
            </section>
        </div>

    </div>
</div>

@endsection

{{-- 
    ======================================================================
    ||   LEMBRETE: Adicionar o CSS e o JavaScript abaixo              ||
    ======================================================================
--}}

{{-- Adicione ao seu arquivo CSS --}}
<style>
    .tab-button {
        padding: 0.75rem 1rem; /* 12px 16px */
        font-size: 1rem; /* 16px */
        font-weight: 600;
        color: #4a5568; /* Cinza escuro para abas inativas */
        border-bottom: 3px solid transparent;
        transition: all 0.2s ease;
        cursor: pointer;
        white-space: nowrap;
    }

    .tab-button:hover {
        color: #2c3e50;
        background-color: #f7fafc; /* Um fundo suave no hover */
    }

    .tab-button.active {
        color: #003F82; /* Cor principal do sistema */
        border-bottom-color: #07509D; /* Cor de destaque, igual à borda do título */
    }

    .tab-content {
        animation: fadeIn 0.4s ease-in-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

{{-- Adicione antes do fechamento da tag </body> --}}
<script>
document.addEventListener('DOMContentLoaded', function () {
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            // Remove a classe 'active' de todos os botões e conteúdos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => {
                content.classList.add('hidden');
                content.classList.remove('active');
            });

            // Adiciona a classe 'active' ao botão clicado
            button.classList.add('active');

            // Exibe o conteúdo correspondente
            const targetId = button.getAttribute('data-target');
            const targetContent = document.getElementById(targetId);
            
            if (targetContent) {
                targetContent.classList.remove('hidden');
                targetContent.classList.add('active');
            }
        });
    });
});
</script>
