<x-guest-layout>
    <x-jet-authentication-card>

        <x-slot name="logo">
            <img src="img/logos.png">
        </x-slot>

        <x-jet-validation-errors class="mb-4" />

        <form method="POST" action="{{ route('register') }}">

            @csrf

            <div>
                <label for="name" class="block text-sm/6 font-semibold text-white">Nome</label>
                <div class="mt-2.5">
                    <input id="name" type="text" name="name" placeholder="Digite seu nome" :value="old('name')" required autofocus class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600">
                </div>
            </div>

            {{-- <div>
                <x-jet-label for="name" value="{{ __('Name') }}" />
            <x-jet-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
            </div> --}}

            <div class="mt-4">
                <x-jet-label for="empresa" value="Empresa" class="text-sm/6 font-semibold text-white" />
                <select id="empresa" name="empresa" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                    <option value="">Selecione sua unidade Stellantis</option>
                    <option value="Betim">Betim</option>
                    <option value="Mopar">Mopar</option>
                </select>
            </div>

            <div class="mt-4">
                <x-jet-label for="email" value="{{ __('Login') }}" class="text-sm/6 font-semibold text-white" />
                <x-jet-input id="email" type="text" name="email" :value="old('email')" placeholder="Digite seu o Login que deseja utilizar" required class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600" />
            </div>
            <div class="mt-4">
                <x-jet-label for="password" value="{{ __('Senha') }}" class="text-sm/6 font-semibold text-white" />
                <x-jet-input id="password" type="password" name="password" placeholder="Digite sua senha" required autocomplete="new-password" class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600" />
            </div>

            <div class="mt-4">
                <x-jet-label for="password_confirmation" value="{{ __('Confirme sua senha') }}" class="text-sm/6 font-semibold text-white" />
                <x-jet-input id="password_confirmation" type="password" name="password_confirmation" placeholder="Digite sua senha" required autocomplete="new-password" class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600" />
            </div>

            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
            <div class="mt-4">
                <x-jet-label for="terms">
                    <div class="flex items-center">
                        <x-jet-checkbox name="terms" id="terms" />

                        <div class="ml-2">
                            {!! __('I agree to the :terms_of_service and :privacy_policy', [
                            'terms_of_service' => '<a target="_blank" href="'.route('terms.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Terms of Service').'</a>',
                            'privacy_policy' => '<a target="_blank" href="'.route('policy.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Privacy Policy').'</a>',
                            ]) !!}
                        </div>
                    </div>
                </x-jet-label>
            </div>
            @endif

            <div class="flex items-center justify-center mt-4">
                <x-jet-button class="ml-4 bg-cyan">
                    {{ __('Registrar') }}
                </x-jet-button>
            </div>

        </form>

        <div class="flex items-center justify-center mt-8">
            <x-jet-button class="ml-4 bg-yellow">
                <a href="/">
                    {{ __('Voltar') }}
                </a>
            </x-jet-button>
        </div>

    </x-jet-authentication-card>
</x-guest-layout>