@extends('layouts.main')

@section('title', 'SafetyStart - Minuto da Percepção')

@section('content')

<div id="block-master-7">

    <h2 class="titleItems mb-3">Minuto da Percepção</h2>

    <p class="textModulo">
        É hora de cadastrar os Atos/Condições inseguras que você identificou! Quanto mais situações você reportar, mais pontos acumulará no nosso game de segurança. Se tiver dúvidas sobre como classificar uma ocorrência, clique nos itens abaixo para entender melhor cada situação. Participe ativamente e ajude a tornar nosso ambiente de trabalho mais seguro enquanto ganha pontos!
    </p>
    <p class="textModulo">Participe do Desafio Diário entre 30 de setembro a 4 de outubro e acumule pontos na sua Jornada de Ouro GT.</p>
    <p class="textModulo">Todos os dias, às 08h (horário de Brasília), será liberada uma nova pergunta, e você terá 24 horas para respondê-la. </p>
    <p class="textModulo">Lembre-se, você só tem uma única chance de acertar! Cada resposta correta vale 5 pontos.</p>
    <p class="textModulo">Vamos participar?</p>

    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @elseif (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif

    <div class="ag-courses_grid">
        @php
            $status1 = Auth::user()->usu_resp_dia1;
            $class1 = $status1 == 0 ? 'ag-status-pendente' : ($status1 == 1 ? 'ag-status-correto' : 'ag-status-errado');
            $href1 = $status1 == 0 ? '/pergunta1' : null;

            $status2 = Auth::user()->usu_resp_dia2;
            $class2 = $status2 == 0 ? 'ag-status-pendente' : ($status2 == 1 ? 'ag-status-correto' : 'ag-status-errado');
            $href2 = $status2 == 0 ? '/pergunta2' : null;
        @endphp

    <form action="{{ route('atos.store') }}" method="POST" class="container mt-4 mb-6">
        @csrf
        
        @php

            $status3 = Auth::user()->usu_resp_dia3;
            $class3 = $status3 == 0 ? 'ag-status-pendente' : ($status3 == 1 ? 'ag-status-correto' : 'ag-status-errado');
            $href3 = $status3 == 0 ? '/pergunta3' : null;

            $status4 = Auth::user()->usu_resp_dia4;
            $class4 = $status4 == 0 ? 'ag-status-pendente' : ($status4 == 1 ? 'ag-status-correto' : 'ag-status-errado');
            $href4 = $status4 == 0 ? '/pergunta4' : null;

            $status5 = Auth::user()->usu_resp_dia5;
            $class5 = $status5 == 0 ? 'ag-status-pendente' : ($status5 == 1 ? 'ag-status-correto' : 'ag-status-errado');
            $href5 = $status5 == 0 ? '/pergunta5' : null;

        @endphp

        <div class="bodyBlue ag-courses_item {{ $class1 }}">
            <a {{ $href1 ? "href=$href1" : '' }} class="ag-courses-item_link" style="{{ !$href1 ? 'pointer-events: none; cursor: default;' : '' }}">
                <div class="ag-courses-item_content">
                    <img src="img/SAFETYSTART.png" width="200" class="img-fluid">
                </div>
            </a>
        </div>


        <div class="bodyBlue ag-courses_item {{ $class2 }}">
            <a {{ $href2 ? "href=$href2" : '' }} class="ag-courses-item_link" style="{{ !$href2 ? 'pointer-events: none; cursor: default;' : '' }}">
                <div class="ag-courses-item_content">
                    <img src="img/SAFETYSTART.png" width="200" class="img-fluid">
                </div>
            </a>
        </div>

        <div class="bodyBlue ag-courses_item {{ $class3 }}">
            <a {{ $href3 ? "href=$href3" : '' }} class="ag-courses-item_link" style="{{ !$href3 ? 'pointer-events: none; cursor: default;' : '' }}">
                <div class="ag-courses-item_content">
                    <img src="img/SAFETYSTART.png" width="200" class="img-fluid">
                </div>
            </a>
        </div>

        <div class="bodyBlue ag-courses_item {{ $class4 }}">
            <a {{ $href4 ? "href=$href4" : '' }} class="ag-courses-item_link" style="{{ !$href4 ? 'pointer-events: none; cursor: default;' : '' }}">
                <div class="ag-courses-item_content">
                    <img src="img/SAFETYSTART.png" width="200" class="img-fluid">
                </div>
            </a>
        </div>

        <div class="bodyBlue ag-courses_item {{ $class5 }}">
            <a {{ $href5 ? "href=$href5" : '' }} class="ag-courses-item_link" style="{{ !$href5 ? 'pointer-events: none; cursor: default;' : '' }}">
                <div class="ag-courses-item_content">
                    <img src="img/SAFETYSTART.png" width="200" class="img-fluid">
                </div>
            </a>
        </div>
        <!-- Repita para os outros módulos -->

    </div>

    @endsection