<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Log extends Model
{
    use HasFactory;

    // Defina a tabela se o nome da tabela for diferente de 'logs'
    protected $table = 'logs';

    // Defina os campos que são atribuíveis em massa
    protected $fillable = [
        'usu_id',
        'log_ip',
        'log_acao',
        'usu_email',
    ];

    // Defina as colunas de timestamps se não estiverem presentes no banco
    public $timestamps = true; // Defina como false se não usar created_at e updated_at
}
